/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.menus.ContributionFactoryGenerator;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;

public class WorkbenchMenuService
implements IMenuService {
    private static final String POPULATED_TOOL_BARS = "populatedToolBars";
    private static final String POPULATED_MENUS = "populatedMenus";
    private IEclipseContext e4Context;
    private ServiceLocator serviceLocator;
    private ExpressionContext legacyContext;
    private MenuPersistence persistence;
    private Map<AbstractContributionFactory, Object> factoriesToContributions = new HashMap<AbstractContributionFactory, Object>();
    private EModelService modelService;

    public WorkbenchMenuService(ServiceLocator serviceLocator, IEclipseContext e4Context) {
        this.serviceLocator = serviceLocator;
        this.e4Context = e4Context;
        this.modelService = (EModelService)e4Context.get(EModelService.class);
        this.persistence = new MenuPersistence((MApplication)e4Context.get(MApplication.class), e4Context);
    }

    @Override
    public void addSourceProvider(ISourceProvider provider) {
    }

    @Override
    public void removeSourceProvider(ISourceProvider provider) {
    }

    @Override
    public void dispose() {
        this.persistence.dispose();
    }

    private boolean inToolbar(MenuLocationURI location) {
        return location.getScheme().startsWith("toolbar");
    }

    @Override
    public void addContributionFactory(AbstractContributionFactory factory) {
        MenuLocationURI location = new MenuLocationURI(factory.getLocation());
        if (location.getPath() == null || location.getPath().length() == 0) {
            WorkbenchPlugin.log("WorkbenchMenuService.addContributionFactory: Invalid menu URI: " + location);
            return;
        }
        if (this.inToolbar(location)) {
            if (!MenuAdditionCacheEntry.isInWorkbenchTrim(location)) {
                String query = location.getQuery();
                if (query == null || query.length() == 0) {
                    query = "after=additions";
                }
                this.processToolbarChildren(factory, location, location.getPath(), query);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.setElementId(String.valueOf(factory.getNamespace()) + ":" + factory.hashCode());
        if ("org.eclipse.ui.popup.any".equals(location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(location.getPath());
        }
        String query = location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(factory, 0);
        menuContribution.getTransientData().put("ContributionFactory", generator);
        this.factoriesToContributions.put(factory, menuContribution);
        MApplication app = (MApplication)this.e4Context.get(MApplication.class);
        app.getMenuContributions().add(menuContribution);
    }

    private void processToolbarChildren(AbstractContributionFactory factory, MenuLocationURI location, String parentId, String position) {
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        toolBarContribution.setElementId(String.valueOf(factory.getNamespace()) + ":" + factory.hashCode());
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + location.getScheme());
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(factory, 1);
        toolBarContribution.getTransientData().put("ToolBarContributionFactory", generator);
        this.factoriesToContributions.put(factory, toolBarContribution);
        MApplication app = (MApplication)this.e4Context.get(MApplication.class);
        app.getToolBarContributions().add(toolBarContribution);
    }

    @Override
    public void removeContributionFactory(AbstractContributionFactory factory) {
        Object contribution = this.factoriesToContributions.remove(factory);
        if (contribution != null) {
            MApplication app = (MApplication)this.e4Context.get(MApplication.class);
            if (app == null) {
                return;
            }
            if (contribution instanceof MMenuContribution) {
                app.getMenuContributions().remove(contribution);
            } else if (contribution instanceof MToolBarContribution) {
                app.getToolBarContributions().remove(contribution);
            }
        }
    }

    protected IWorkbenchWindow getWindow() {
        IWorkbench wb;
        if (this.serviceLocator == null) {
            return null;
        }
        IWorkbenchLocationService wls = (IWorkbenchLocationService)this.serviceLocator.getService(IWorkbenchLocationService.class);
        IWorkbenchWindow window = null;
        if (window == null) {
            window = wls.getWorkbenchWindow();
        }
        if (window == null && (wb = wls.getWorkbench()) != null) {
            window = wb.getActiveWorkbenchWindow();
        }
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return window;
    }

    @Override
    public void populateContributionManager(ContributionManager mgr, String location) {
        IWorkbenchWindow window;
        MPart model = this.getPartToExtend();
        if (model == null && (window = this.getWindow()) instanceof WorkbenchWindow) {
            model = ((WorkbenchWindow)window).getModel();
        }
        this.populateContributionManager((MApplicationElement)model, mgr, location);
    }

    public void populateContributionManager(MApplicationElement model, ContributionManager mgr, String location) {
        MenuLocationURI uri = new MenuLocationURI(location);
        if (mgr instanceof MenuManager) {
            MenuManager menu = (MenuManager)mgr;
            MMenu mMenu = this.getMenuModel(model, menu, uri);
            if (mMenu == null) {
                return;
            }
            IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
            AbstractPartRenderer obj = factory.getRenderer((MUIElement)mMenu, null);
            if (obj instanceof MenuManagerRenderer) {
                MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
                mMenu.setRenderer((Object)renderer);
                renderer.reconcileManagerToModel(menu, mMenu);
                renderer.processContributions(mMenu, uri.getPath(), false, "popup".equals(uri.getScheme()));
                renderer.processContents((MElementContainer)mMenu);
                IEclipseContext evalContext = mMenu instanceof MContext ? ((MContext)mMenu).getContext() : this.modelService.getContainingContext((MUIElement)mMenu);
                MenuManagerRendererFilter.updateElementVisibility((MMenu)mMenu, (MenuManagerRenderer)renderer, (MenuManager)menu, (IEclipseContext)evalContext, (int)2, (boolean)true);
            }
        } else if (mgr instanceof ToolBarManager) {
            ToolBarManager toolbar = (ToolBarManager)mgr;
            MToolBar mToolBar = this.getToolbarModel(model, toolbar, uri);
            if (mToolBar == null) {
                return;
            }
            IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
            AbstractPartRenderer obj = factory.getRenderer((MUIElement)mToolBar, null);
            if (obj instanceof ToolBarManagerRenderer) {
                ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)obj;
                mToolBar.setRenderer((Object)renderer);
                renderer.reconcileManagerToModel((IToolBarManager)toolbar, mToolBar);
                renderer.processContribution(mToolBar, uri.getPath());
                renderer.processContents((MElementContainer)mToolBar);
            }
        } else {
            WorkbenchPlugin.log("populateContributionManager: Unhandled manager: " + mgr);
        }
    }

    protected MToolBar getToolbarModel(MApplicationElement model, ToolBarManager toolbarManager, MenuLocationURI location) {
        IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)MenuFactoryImpl.eINSTANCE.createToolBar(), null);
        if (!(obj instanceof ToolBarManagerRenderer)) {
            return null;
        }
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)obj;
        MToolBar mToolBar = renderer.getToolBarModel(toolbarManager);
        if (mToolBar != null) {
            String tag = "toolbar:" + location.getPath();
            if (!mToolBar.getTags().contains(tag)) {
                mToolBar.getTags().add(tag);
            }
            return mToolBar;
        }
        if (mToolBar == null) {
            mToolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
            mToolBar.setElementId(location.getPath());
            mToolBar.getTags().add("menuContribution:toolbar");
            String tag = "toolbar:" + location.getPath();
            mToolBar.getTags().add(tag);
            this.addToolbar(model, mToolBar, ((MContext)model).getContext());
        }
        renderer.linkModelToManager(mToolBar, toolbarManager);
        return mToolBar;
    }

    private void addToolbar(MApplicationElement model, MToolBar tb, IEclipseContext ctx) {
        ArrayList<MToolBar> toolbars = (ArrayList<MToolBar>)model.getTransientData().get(POPULATED_TOOL_BARS);
        if (toolbars == null) {
            toolbars = new ArrayList<MToolBar>();
            model.getTransientData().put(POPULATED_TOOL_BARS, toolbars);
        }
        if (toolbars.contains(tb)) {
            return;
        }
        toolbars.add(tb);
        tb.getTransientData().put("ModelUtils.containingParent", model);
        ((Notifier)tb).eAdapters().add((Object)((Adapter)ctx.get(UIEventPublisher.class)));
    }

    private void addMenu(MApplicationElement model, MMenu menu, IEclipseContext ctx) {
        ArrayList<MMenu> menus = (ArrayList<MMenu>)model.getTransientData().get(POPULATED_MENUS);
        if (menus == null) {
            menus = new ArrayList<MMenu>();
            model.getTransientData().put(POPULATED_MENUS, menus);
        }
        if (menus.contains(menu)) {
            return;
        }
        menus.add(menu);
        menu.getTransientData().put("ModelUtils.containingParent", model);
        ((Notifier)menu).eAdapters().add((Object)((Adapter)ctx.get(UIEventPublisher.class)));
    }

    protected MMenu getMenuModel(MApplicationElement model, MenuManager menuManager, MenuLocationURI location) {
        IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)((WorkbenchWindow)this.getWindow()).getModel().getMainMenu(), null);
        if (!(obj instanceof MenuManagerRenderer)) {
            return null;
        }
        MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
        MMenu mMenu = renderer.getMenuModel(menuManager);
        if (mMenu != null) {
            String tag = "popup".equals(location.getScheme()) ? "popup:" + location.getPath() : "menu:" + location.getPath();
            if (!mMenu.getTags().contains(tag)) {
                mMenu.getTags().add(tag);
            }
            return mMenu;
        }
        if (mMenu == null) {
            String tag;
            mMenu = MenuFactoryImpl.eINSTANCE.createMenu();
            mMenu.setElementId(menuManager.getId());
            if (mMenu.getElementId() == null) {
                mMenu.setElementId(location.getPath());
            }
            if ("popup".equals(location.getScheme())) {
                mMenu.getTags().add("menuContribution:popup");
                tag = "popup:" + location.getPath();
            } else {
                mMenu.getTags().add("menuContribution:menu");
                tag = "menu:" + location.getPath();
            }
            mMenu.getTags().add(tag);
            mMenu.setLabel(menuManager.getMenuText());
            this.addMenu(model, mMenu, ((MContext)model).getContext());
        }
        renderer.linkModelToManager(mMenu, menuManager);
        return mMenu;
    }

    private MPart getPartToExtend() {
        return (MPart)this.e4Context.getActiveLeaf().get("e4ActivePart");
    }

    @Override
    public void releaseContributions(ContributionManager mgr) {
        if (mgr instanceof MenuManager) {
            MenuManager menu = (MenuManager)mgr;
            this.releaseContributionManager(menu);
        } else if (mgr instanceof ToolBarManager) {
            ToolBarManager toolbar = (ToolBarManager)mgr;
            this.releaseContributionManager(toolbar);
        } else {
            WorkbenchPlugin.log("releaseContributions: Unhandled manager: " + mgr);
        }
    }

    private void releaseContributionManager(ToolBarManager toolbarManager) {
        ToolBar widget;
        IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)MenuFactoryImpl.eINSTANCE.createToolBar(), null);
        if (!(obj instanceof ToolBarManagerRenderer)) {
            return;
        }
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)obj;
        MToolBar mToolBar = renderer.getToolBarModel(toolbarManager);
        if (mToolBar == null) {
            return;
        }
        MApplicationElement model = (MApplicationElement)mToolBar.getTransientData().get("ModelUtils.containingParent");
        if (model != null) {
            ((Notifier)mToolBar).eAdapters().clear();
            ArrayList toolbars = (ArrayList)model.getTransientData().get(POPULATED_TOOL_BARS);
            if (toolbars != null) {
                toolbars.remove(mToolBar);
            }
        }
        if ((widget = toolbarManager.getControl()) != null && !widget.isDisposed() && widget.getData("modelElement") == null) {
            widget.setData("modelElement", (Object)mToolBar);
        }
        IPresentationEngine engine = (IPresentationEngine)this.e4Context.get(IPresentationEngine.class);
        engine.removeGui((MUIElement)mToolBar);
        mToolBar.getTransientData().remove("ModelUtils.containingParent");
    }

    private void releaseContributionManager(MenuManager menuManager) {
        Menu widget;
        IRendererFactory factory = (IRendererFactory)this.e4Context.get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)((WorkbenchWindow)this.getWindow()).getModel().getMainMenu(), null);
        if (!(obj instanceof MenuManagerRenderer)) {
            return;
        }
        MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
        MMenu mMenu = renderer.getMenuModel(menuManager);
        if (mMenu == null) {
            return;
        }
        MApplicationElement model = (MApplicationElement)mMenu.getTransientData().get("ModelUtils.containingParent");
        if (model != null) {
            ((Notifier)mMenu).eAdapters().clear();
            ArrayList menus = (ArrayList)model.getTransientData().get(POPULATED_MENUS);
            if (menus != null) {
                menus.remove(mMenu);
            }
        }
        if ((widget = menuManager.getMenu()) != null && !widget.isDisposed() && widget.getData("modelElement") == null) {
            widget.setData("modelElement", (Object)mMenu);
        }
        IPresentationEngine engine = (IPresentationEngine)this.e4Context.get(IPresentationEngine.class);
        engine.removeGui((MUIElement)mMenu);
        mMenu.getTransientData().remove("ModelUtils.containingParent");
    }

    @Override
    public IEvaluationContext getCurrentState() {
        if (this.legacyContext == null) {
            this.legacyContext = new ExpressionContext(this.e4Context);
        }
        return this.legacyContext;
    }

    public void readRegistry() {
        this.persistence.read();
    }
}

