/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo.UstDebugInfoSymbolProvider;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.AbstractSymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;

public class UstDebugInfoSymbolProviderPreferencePage
extends AbstractSymbolProviderPreferencePage {
    private @Nullable Button fUseCustomDirectoryCheckbox;
    private @Nullable Text fCustomDirectoryPath;
    private @Nullable Button fBrowseButton;
    private @Nullable Button fClearButton;

    public UstDebugInfoSymbolProviderPreferencePage(UstDebugInfoSymbolProvider provider) {
        super((ISymbolProvider)provider);
        this.setDescription(MessageFormat.format(Messages.PreferencePage_WindowDescription, provider.getTrace().getName()));
        this.setValid(true);
    }

    public UstDebugInfoSymbolProvider getSymbolProvider() {
        return (UstDebugInfoSymbolProvider)super.getSymbolProvider();
    }

    protected Control createContents(@Nullable Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        Button checkBox = new Button(composite, 32);
        checkBox.setText(Messages.PreferencePage_CheckboxLabel);
        checkBox.setToolTipText(Messages.PreferencePage_CheckboxTooltip);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                UstDebugInfoSymbolProviderPreferencePage.this.updateContents();
            }
        });
        this.fUseCustomDirectoryCheckbox = checkBox;
        new Label(composite, 0);
        new Label(composite, 0);
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(false);
        text.setToolTipText(Messages.PreferencePage_CheckboxTooltip);
        this.fCustomDirectoryPath = text;
        Button browseButton = new Button(composite, 0);
        browseButton.setText(Messages.PreferencePage_ButtonBrowse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                UstDebugInfoSymbolProviderPreferencePage.this.browseDirectory((Text)NonNullUtils.checkNotNull((Object)UstDebugInfoSymbolProviderPreferencePage.this.fCustomDirectoryPath), Messages.PreferencePage_BrowseDialogTitle);
            }
        });
        this.fBrowseButton = browseButton;
        Button clearButton = new Button(composite, 0);
        clearButton.setText(Messages.PreferencePage_ButtonClear);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ((Text)NonNullUtils.checkNotNull((Object)UstDebugInfoSymbolProviderPreferencePage.this.fCustomDirectoryPath)).setText("");
                UstDebugInfoSymbolProviderPreferencePage.this.updateContents();
            }
        });
        this.fClearButton = clearButton;
        this.loadCurrentSettings();
        return composite;
    }

    private void browseDirectory(Text textField, @Nullable String dialogTitle) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(dialogTitle);
        String dirPath = dialog.open();
        if (dirPath != null) {
            textField.setText(dirPath);
            this.updateContents();
        }
    }

    private void loadCurrentSettings() {
        LttngUstTrace trace = this.getSymbolProvider().getTrace();
        LttngUstTrace.SymbolProviderConfig config = trace.getSymbolProviderConfig();
        ((Button)NonNullUtils.checkNotNull((Object)this.fUseCustomDirectoryCheckbox)).setSelection(config.useCustomRootDir());
        ((Text)NonNullUtils.checkNotNull((Object)this.fCustomDirectoryPath)).setText(config.getCustomRootDirPath());
        this.updateContents();
    }

    public void saveConfiguration() {
        LttngUstTrace.SymbolProviderConfig config = new LttngUstTrace.SymbolProviderConfig(this.getCurrentCheckBoxState(), this.getCurrentPathPrefix());
        LttngUstTrace trace = this.getSymbolProvider().getTrace();
        trace.setSymbolProviderConfig(config);
    }

    private boolean getCurrentCheckBoxState() {
        return ((Button)NonNullUtils.checkNotNull((Object)this.fUseCustomDirectoryCheckbox)).getSelection();
    }

    private String getCurrentPathPrefix() {
        return NonNullUtils.nullToEmptyString((Object)((Text)NonNullUtils.checkNotNull((Object)this.fCustomDirectoryPath)).getText());
    }

    private void updateContents() {
        boolean useCustomDirEnabled = this.getCurrentCheckBoxState();
        ((Text)NonNullUtils.checkNotNull((Object)this.fCustomDirectoryPath)).setEnabled(useCustomDirEnabled);
        ((Button)NonNullUtils.checkNotNull((Object)this.fBrowseButton)).setEnabled(useCustomDirEnabled);
        ((Button)NonNullUtils.checkNotNull((Object)this.fClearButton)).setEnabled(useCustomDirEnabled);
        String errorMessage = null;
        if (useCustomDirEnabled) {
            String pathPrefix = this.getCurrentPathPrefix();
            Path path = Paths.get(pathPrefix, new String[0]);
            if (pathPrefix.equals("") || !Files.isDirectory(path, new LinkOption[0])) {
                errorMessage = Messages.PreferencePage_ErrorDirectoryDoesNotExists;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }
}

