/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClassType
extends PlatformObject
implements ICPPInternalClassTypeMixinHost {
    private IASTName definition;
    private IASTName[] declarations;
    private boolean checked;
    private ICPPClassType typeInIndex;
    private ICPPBase[] bases;

    public CPPClassType(IASTName name, IBinding indexBinding) {
        name = this.stripQualifier(name);
        IASTNode parent = name.getParent();
        while (parent instanceof IASTName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTCompositeTypeSpecifier) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
        if (indexBinding instanceof ICPPClassType && indexBinding instanceof IIndexBinding) {
            this.typeInIndex = (ICPPClassType)indexBinding;
        }
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.definition;
    }

    @Override
    public void checkForDefinition() {
        if (!this.checked) {
            IIndex index;
            if (this.definition == null && this.typeInIndex == null && (index = this.getPhysicalNode().getTranslationUnit().getIndex()) != null) {
                this.typeInIndex = (ICPPClassType)((Object)index.adaptBinding(this));
            }
            this.checked = true;
        }
    }

    @Override
    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    private ICPPASTElaboratedTypeSpecifier getElaboratedTypeSpecifier() {
        if (this.declarations != null) {
            IASTNode node = this.declarations[0];
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTElaboratedTypeSpecifier) {
                return (ICPPASTElaboratedTypeSpecifier)node;
            }
        }
        return null;
    }

    @Override
    public final String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.definition != null ? this.definition.getSimpleID() : this.declarations[0].getSimpleID();
    }

    @Override
    public IScope getScope() {
        IASTNode node;
        IASTName name = this.definition != null ? this.definition : this.declarations[0];
        name = this.stripQualifier(name);
        IScope scope = CPPVisitor.getContainingScope(name);
        if (this.definition == null && name.getPropertyInParent() != ICPPASTQualifiedName.SEGMENT_NAME && (!((node = this.declarations[0].getParent().getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)node).getDeclarators().length != 0 || this.getElaboratedTypeSpecifier().isFriend())) {
            while (scope instanceof ICPPClassScope || scope instanceof ICPPFunctionScope) {
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
        return scope;
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        IScope scope;
        this.checkForDefinition();
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getScope();
        }
        if (this.typeInIndex != null && (scope = this.typeInIndex.getCompositeScope()) instanceof ICPPClassScope) {
            return (ICPPClassScope)scope;
        }
        return null;
    }

    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    @Override
    public int getKey() {
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getElaboratedTypeSpecifier().getKind();
    }

    @Override
    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.definition = ((ICPPASTCompositeTypeSpecifier)node).getName();
        } else assert (false);
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (node instanceof ICPPASTElaboratedTypeSpecifier) {
            IASTName name = ((ICPPASTElaboratedTypeSpecifier)node).getName();
            if (this.declarations == null) {
                this.declarations = new IASTName[]{name};
                return;
            }
            this.declarations = this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.declarations, name) : ArrayUtil.append(IASTName.class, this.declarations, name);
        } else assert (false);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    @Override
    public ICPPBase[] getBases() {
        if (this.bases == null) {
            this.bases = ClassTypeHelper.getBases(this);
        }
        return this.bases;
    }

    @Override
    public IField[] getFields() {
        return ClassTypeHelper.getFields(this, null);
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ClassTypeHelper.getDeclaredFields(this);
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this, null);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this, null);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ClassTypeHelper.getDeclaredMethods(this);
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return ClassTypeHelper.getConstructors(this);
    }

    @Override
    public IBinding[] getFriends() {
        return ClassTypeHelper.getFriends(this);
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ClassTypeHelper.getNestedClasses(this);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IBinding getOwner() {
        if (this.definition != null) {
            return CPPVisitor.findNameOwner(this.definition, true);
        }
        return CPPVisitor.findDeclarationOwner(this.declarations[0], true);
    }

    @Override
    public boolean isAnonymous() {
        IASTNode node;
        if (this.getNameCharArray().length > 0) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier spec = this.getCompositeTypeSpecifier();
        return spec != null && (node = spec.getParent()) instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)node).getDeclarators().length == 0;
    }

    @Override
    public boolean isFinal() {
        ICPPASTCompositeTypeSpecifier typeSpecifier = this.getCompositeTypeSpecifier();
        if (typeSpecifier != null) {
            return typeSpecifier.isFinal();
        }
        return false;
    }

    private IASTName stripQualifier(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            name = ((ICPPASTQualifiedName)name).getLastName();
        }
        return name;
    }

    @Override
    public int getVisibility(IBinding member) {
        return ClassTypeHelper.getVisibility(this, member);
    }

    public static class CPPClassTypeProblem
    extends ProblemBinding
    implements ICPPClassType {
        public CPPClassTypeProblem(IASTName name, int id) {
            super(name, id);
        }

        public CPPClassTypeProblem(ICPPASTNameSpecifier nameSpec, int id) {
            super(nameSpec, id, nameSpec instanceof IASTName ? null : nameSpec.toCharArray());
        }

        public CPPClassTypeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public ICPPBase[] getBases() {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }

        @Override
        public IField[] getFields() {
            return IField.EMPTY_FIELD_ARRAY;
        }

        @Override
        public ICPPField[] getDeclaredFields() {
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }

        @Override
        public ICPPMethod[] getMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        @Override
        public ICPPMethod[] getAllDeclaredMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        @Override
        public ICPPMethod[] getDeclaredMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        @Override
        public ICPPConstructor[] getConstructors() {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }

        @Override
        public int getKey() {
            return 3;
        }

        @Override
        public IField findField(String name) {
            return null;
        }

        @Override
        public IScope getCompositeScope() {
            return this;
        }

        @Override
        public IBinding[] getFriends() {
            return IBinding.EMPTY_BINDING_ARRAY;
        }

        @Override
        public ICPPClassType[] getNestedClasses() {
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public int getVisibility(IBinding member) {
            throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
        }
    }
}

