/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class CPPFunctionType
implements ICPPFunctionType,
ISerializableType {
    private final IType[] parameters;
    private final IType returnType;
    private final boolean isConst;
    private final boolean isVolatile;
    private final boolean hasRefQualifier;
    private final boolean isRValueReference;
    private final boolean takesVarargs;

    public CPPFunctionType(IType returnType, IType[] types) {
        this(returnType, types, false, false, false, false, false);
    }

    public CPPFunctionType(IType returnType, IType[] types, boolean isConst, boolean isVolatile, boolean hasRefQualifier, boolean isRValueReference, boolean takesVarargs) {
        this.returnType = returnType;
        this.parameters = types;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.hasRefQualifier = hasRefQualifier;
        this.isRValueReference = isRValueReference;
        this.takesVarargs = takesVarargs;
    }

    @Override
    public boolean isSameType(IType o) {
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (o instanceof ICPPFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)o;
            if (this.isConst() != ft.isConst() || this.isVolatile() != ft.isVolatile() || this.hasRefQualifier() != ft.hasRefQualifier() || this.isRValueReference() != ft.isRValueReference() || this.takesVarArgs() != ft.takesVarArgs()) {
                return false;
            }
            IType[] fps = ft.getParameterTypes();
            if (this.returnType == null ^ ft.getReturnType() == null) {
                return false;
            }
            if (this.returnType != null && !this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
            if (this.parameters.length == fps.length) {
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i] == null || !this.parameters[i].isSameType(fps[i])) {
                        return false;
                    }
                    ++i;
                }
            } else if (!SemanticUtil.isEmptyParameterList(this.parameters) || !SemanticUtil.isEmptyParameterList(fps)) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IType getReturnType() {
        return this.returnType;
    }

    @Override
    public IType[] getParameterTypes() {
        return this.parameters;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    @Deprecated
    public IPointerType getThisType() {
        return null;
    }

    @Override
    public final boolean isConst() {
        return this.isConst;
    }

    @Override
    public final boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean hasRefQualifier() {
        return this.hasRefQualifier;
    }

    @Override
    public boolean isRValueReference() {
        return this.isRValueReference;
    }

    @Override
    public boolean takesVarArgs() {
        return this.takesVarargs;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 5;
        if (this.isConst) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.takesVarargs) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.isVolatile) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        if (this.hasRefQualifier) {
            firstBytes = (short)(firstBytes | 0x100);
        }
        if (this.isRValueReference) {
            firstBytes = (short)(firstBytes | 0x200);
        }
        buffer.putShort(firstBytes);
        buffer.putInt(this.parameters.length);
        buffer.marshalType(this.returnType);
        int i = 0;
        while (i < this.parameters.length) {
            buffer.marshalType(this.parameters[i]);
            ++i;
        }
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        IType rt = buffer.unmarshalType();
        IType[] pars = new IType[len];
        int i = 0;
        while (i < pars.length) {
            pars[i] = buffer.unmarshalType();
            ++i;
        }
        boolean isConst = (firstBytes & 0x20) != 0;
        boolean takesVarargs = (firstBytes & 0x40) != 0;
        boolean isVolatile = (firstBytes & 0x80) != 0;
        boolean hasRefQualifier = (firstBytes & 0x100) != 0;
        boolean isRValueReference = (firstBytes & 0x200) != 0;
        return new CPPFunctionType(rt, pars, isConst, isVolatile, hasRefQualifier, isRValueReference, takesVarargs);
    }
}

