/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.store;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public class ArrayListStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private final Comparator<E> COMPARATOR = (o1, o2) -> {
        int ret = Long.compare(o1.getStart(), o2.getStart());
        if (ret == 0) {
            return Long.compare(o1.getEnd(), o2.getEnd());
        }
        return ret;
    };
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final List<E> fStore = new ArrayList();
    private transient @Nullable Iterable<E> fLastSnapshot = null;

    public ArrayListStore() {
    }

    public ArrayListStore(Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ISegment) {
                this.fStore.add((ISegment)array[i]);
            }
            ++i;
        }
        this.fStore.sort(this.COMPARATOR);
    }

    public Iterator<E> iterator() {
        this.fLock.readLock().lock();
        try {
            ImmutableList lastSnapshot = this.fLastSnapshot;
            if (lastSnapshot == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add null value");
        }
        this.fLock.writeLock().lock();
        try {
            this.fStore.add(val);
            int i = this.size() - 1;
            while (i > 0 && this.COMPARATOR.compare(val, (ISegment)this.fStore.get(i - 1)) < 0) {
                Collections.swap(this.fStore, i, i - 1);
                --i;
            }
            this.fLastSnapshot = null;
            return true;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public int size() {
        return this.fStore.size();
    }

    public boolean isEmpty() {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.isEmpty();
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public boolean contains(@Nullable Object o) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.contains(o);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.readLock().lock();
        try {
            boolean bl = this.fStore.containsAll(c);
            return bl;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public Object[] toArray() {
        this.fLock.readLock().lock();
        try {
            Object[] objectArray = this.fStore.toArray();
            return objectArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public <T> T[] toArray(T[] a) {
        this.fLock.readLock().lock();
        try {
            T[] TArray = this.fStore.toArray(a);
            return TArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.writeLock().lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public boolean removeAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.fLock.writeLock().lock();
        try {
            this.fStore.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public Iterable<E> getIntersectingElements(long position) {
        this.fLock.readLock().lock();
        try {
            Iterable iterable = this.fStore.stream().filter(element -> position >= element.getStart() && position <= element.getEnd()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.readLock().lock();
        try {
            Iterable iterable = this.fStore.stream().filter(element -> start <= element.getEnd() && end >= element.getStart()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public void dispose() {
        this.fLock.writeLock().lock();
        try {
            this.fStore.clear();
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }
}

