/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

@NonNullByDefault
public class TransientState {
    private final IStateHistoryBackend fBackend;
    private final ReentrantReadWriteLock fRWLock = new ReentrantReadWriteLock(false);
    private volatile boolean fIsActive;
    private volatile long fLatestTime;
    private List<ITmfStateValue> fOngoingStateInfo;
    private List<Long> fOngoingStateStartTimes;
    private List<ITmfStateValue.Type> fStateValueTypes;

    public TransientState(IStateHistoryBackend backend) {
        this.fBackend = backend;
        this.fIsActive = true;
        this.fOngoingStateInfo = new ArrayList<ITmfStateValue>();
        this.fOngoingStateStartTimes = new ArrayList<Long>();
        this.fStateValueTypes = new ArrayList<ITmfStateValue.Type>();
        this.fLatestTime = backend.getStartTime();
    }

    public long getLatestTime() {
        return this.fLatestTime;
    }

    public ITmfStateValue getOngoingStateValue(int quark) {
        this.fRWLock.readLock().lock();
        try {
            ITmfStateValue iTmfStateValue = this.fOngoingStateInfo.get(quark);
            return iTmfStateValue;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public long getOngoingStartTime(int quark) {
        this.fRWLock.readLock().lock();
        try {
            long l = this.fOngoingStateStartTimes.get(quark);
            return l;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public void changeOngoingStateValue(int quark, ITmfStateValue newValue) {
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo.set(quark, newValue);
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public ITmfStateInterval getOngoingInterval(int quark) {
        this.fRWLock.readLock().lock();
        try {
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.fOngoingStateStartTimes.get(quark), this.fLatestTime, quark, this.fOngoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public @Nullable ITmfStateInterval getIntervalAt(long time, int quark) {
        this.fRWLock.readLock().lock();
        try {
            if (!this.isActive() || time < this.fOngoingStateStartTimes.get(quark)) {
                return null;
            }
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.fOngoingStateStartTimes.get(quark), this.fLatestTime, quark, this.fOngoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public void replaceOngoingState(List<ITmfStateInterval> newStateIntervals) {
        int size = newStateIntervals.size();
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo = new ArrayList<ITmfStateValue>(size);
            this.fOngoingStateStartTimes = new ArrayList<Long>(size);
            this.fStateValueTypes = new ArrayList<ITmfStateValue.Type>(size);
            for (ITmfStateInterval interval : newStateIntervals) {
                this.fOngoingStateInfo.add(interval.getStateValue());
                this.fOngoingStateStartTimes.add(interval.getStartTime());
                this.fStateValueTypes.add(interval.getStateValue().getType());
            }
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void addEmptyEntry() {
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo.add(TmfStateValue.nullValue());
            this.fStateValueTypes.add(ITmfStateValue.Type.NULL);
            this.fOngoingStateStartTimes.add(this.fBackend.getStartTime());
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void processStateChange(long eventTime, ITmfStateValue value, int quark) throws TimeRangeException, StateValueTypeException {
        if (!this.fIsActive) {
            return;
        }
        this.fRWLock.writeLock().lock();
        try {
            ITmfStateValue.Type expectedSvType = this.fStateValueTypes.get(quark);
            if (expectedSvType == ITmfStateValue.Type.NULL) {
                this.fStateValueTypes.set(quark, value.getType());
            } else if (value.getType() != ITmfStateValue.Type.NULL && value.getType() != expectedSvType) {
                throw new StateValueTypeException(String.valueOf(this.fBackend.getSSID()) + " Quark:" + quark + ", Type:" + (Object)((Object)value.getType()) + ", Expected:" + (Object)((Object)expectedSvType));
            }
            if (this.fOngoingStateInfo.get(quark).equals(value)) {
                return;
            }
            if (this.fOngoingStateStartTimes.get(quark) < eventTime) {
                this.fBackend.insertPastState(this.fOngoingStateStartTimes.get(quark), eventTime - 1L, quark, this.fOngoingStateInfo.get(quark));
                this.fOngoingStateStartTimes.set(quark, eventTime);
            }
            this.fOngoingStateInfo.set(quark, value);
            if (this.fLatestTime < eventTime) {
                this.fLatestTime = eventTime;
            }
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void doQuery(List<@Nullable ITmfStateInterval> stateInfo, long t) {
        this.fRWLock.readLock().lock();
        try {
            if (!this.fIsActive) {
                return;
            }
            if (stateInfo.size() > this.fOngoingStateInfo.size()) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < stateInfo.size()) {
                ITmfStateInterval interval = this.getIntervalAt(t, i);
                if (interval != null) {
                    stateInfo.set(i, interval);
                }
                ++i;
            }
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public void closeTransientState(long endTime) {
        if (!this.fIsActive) {
            return;
        }
        this.fRWLock.writeLock().lock();
        try {
            int i = 0;
            while (i < this.fOngoingStateInfo.size()) {
                if (this.fOngoingStateStartTimes.get(i) <= endTime) {
                    try {
                        this.fBackend.insertPastState(this.fOngoingStateStartTimes.get(i), endTime, i, this.fOngoingStateInfo.get(i));
                    }
                    catch (TimeRangeException e) {
                        throw new IllegalStateException(e);
                    }
                }
                ++i;
            }
            this.fOngoingStateInfo.clear();
            this.fOngoingStateStartTimes.clear();
            this.fIsActive = false;
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setInactive() {
        this.fIsActive = false;
    }

    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Info stored in the Builder:");
        if (!this.fIsActive) {
            writer.println("Builder is currently inactive");
            writer.println('\n');
            return;
        }
        writer.println("\nAttribute\tStateValue\tValid since time");
        int i = 0;
        while (i < this.fOngoingStateInfo.size()) {
            writer.format("%d\t\t", i);
            writer.print(String.valueOf(this.fOngoingStateInfo.get(i).toString()) + "\t\t");
            writer.println(this.fOngoingStateStartTimes.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }
}

