/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.statevalue;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;

public class SafeByteBufferWrapper
implements ISafeByteBufferReader,
ISafeByteBufferWriter {
    private final ByteBuffer fBuffer;

    public SafeByteBufferWrapper(ByteBuffer buffer) {
        this.fBuffer = buffer;
    }

    @Override
    public byte get() {
        return this.fBuffer.get();
    }

    @Override
    public void get(byte[] dst) {
        this.fBuffer.get(dst);
    }

    @Override
    public char getChar() {
        return this.fBuffer.getChar();
    }

    @Override
    public double getDouble() {
        return this.fBuffer.getDouble();
    }

    @Override
    public float getFloat() {
        return this.fBuffer.getFloat();
    }

    @Override
    public int getInt() {
        return this.fBuffer.getInt();
    }

    @Override
    public long getLong() {
        return this.fBuffer.getLong();
    }

    @Override
    public short getShort() {
        return this.fBuffer.getShort();
    }

    @Override
    public String getString() {
        short strSize = this.fBuffer.getShort();
        byte[] array = new byte[strSize];
        this.fBuffer.get(array);
        return new String(array);
    }

    @Override
    public void put(byte value) {
        this.fBuffer.put(value);
    }

    @Override
    public void put(byte[] src) {
        this.fBuffer.put(src);
    }

    @Override
    public void putChar(char value) {
        this.fBuffer.putChar(value);
    }

    @Override
    public void putDouble(double value) {
        this.fBuffer.putDouble(value);
    }

    @Override
    public void putFloat(float value) {
        this.fBuffer.putFloat(value);
    }

    @Override
    public void putInt(int value) {
        this.fBuffer.putInt(value);
    }

    @Override
    public void putLong(long value) {
        this.fBuffer.putLong(value);
    }

    @Override
    public void putShort(short value) {
        this.fBuffer.putShort(value);
    }

    @Override
    public void putString(String value) {
        String toWrite = value;
        if (value.length() > Short.MAX_VALUE) {
            toWrite = toWrite.substring(0, Short.MAX_VALUE);
        }
        this.fBuffer.putShort((short)value.length());
        this.fBuffer.put(toWrite.getBytes());
    }

    public static int getStringSizeInBuffer(String string) {
        return 2 + Math.min(Short.MAX_VALUE, string.length());
    }
}

