/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class SoftIrqExitHandler
extends KernelEventHandler {
    public SoftIrqExitHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldVec()}).getValue()).intValue();
        int currentThreadNode = KernelEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeSoftIRQs(cpu, ss), new String[]{softIrqId.toString()});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        if (SoftIrqExitHandler.isSoftIrqRaised(ss.queryOngoingState(quark))) {
            ss.modifyAttribute(timestamp, StateValues.SOFT_IRQ_RAISED_VALUE, quark);
        } else {
            ss.modifyAttribute(timestamp, (ITmfStateValue)TmfStateValue.nullValue(), quark);
        }
        List softIrqs = ss.getSubAttributes(ss.getParentAttributeQuark(quark), false);
        for (Integer softIrq : softIrqs) {
            if (ss.queryOngoingState(softIrq.intValue()).isNull()) continue;
            return;
        }
        KernelEventHandlerUtils.setProcessToRunning(timestamp, currentThreadNode, ss);
        KernelEventHandlerUtils.cpuExitInterrupt(timestamp, cpu, ss);
    }

    private static boolean isSoftIrqRaised(@Nullable ITmfStateValue state) {
        return state != null && !state.isNull() && (state.unboxInt() & 1) == 1;
    }
}

