/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class StateDumpHandler
extends KernelEventHandler {
    public StateDumpHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        int tid = ((Long)content.getField(new String[]{"tid"}).getValue()).intValue();
        int pid = ((Long)content.getField(new String[]{"pid"}).getValue()).intValue();
        int ppid = ((Long)content.getField(new String[]{"ppid"}).getValue()).intValue();
        int status = ((Long)content.getField(new String[]{"status"}).getValue()).intValue();
        String name = (String)NonNullUtils.checkNotNull((Object)((String)content.getField(new String[]{"name"}).getValue()));
        String threadAttributeName = Attributes.buildThreadAttributeName(tid, cpu);
        if (threadAttributeName == null) {
            return;
        }
        int curThreadNode = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{threadAttributeName});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        StateDumpHandler.setProcessName(ss, name, curThreadNode, timestamp);
        StateDumpHandler.setPpid(ss, tid, pid, ppid, curThreadNode, timestamp);
        StateDumpHandler.setStatus(ss, status, curThreadNode, timestamp);
    }

    private static void setStatus(ITmfStateSystemBuilder ss, int status, int curThreadNode, long timestamp) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Status"});
        if (ss.queryOngoingState(quark).isNull()) {
            ITmfStateValue value;
            switch (status) {
                case 2: {
                    value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                    break;
                }
                case 5: {
                    value = StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE;
                    break;
                }
                default: {
                    value = StateValues.PROCESS_STATUS_UNKNOWN_VALUE;
                }
            }
            ss.modifyAttribute(timestamp, value, quark);
        }
    }

    private static void setPpid(ITmfStateSystemBuilder ss, int tid, int pid, int ppid, int curThreadNode, long timestamp) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"});
        if (ss.queryOngoingState(quark).isNull()) {
            TmfStateValue value = pid == tid ? TmfStateValue.newValueInt((int)ppid) : TmfStateValue.newValueInt((int)pid);
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
    }

    private static void setProcessName(ITmfStateSystemBuilder ss, String name, int curThreadNode, long timestamp) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
        if (ss.queryOngoingState(quark).isNull()) {
            TmfStateValue value = TmfStateValue.newValueString((String)name);
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
    }
}

