/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;

public final class TypeAliasTargetParser
extends AbstractScopedCommonTreeParser {
    public static final TypeAliasTargetParser INSTANCE = new TypeAliasTargetParser();

    private TypeAliasTargetParser() {
    }

    @Override
    public IDeclaration parse(CommonTree target, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List children = target.getChildren();
        CommonTree typeSpecifierList = null;
        CommonTree typeDeclaratorList = null;
        CommonTree typeDeclarator = null;
        StringBuilder identifierSB = new StringBuilder();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 115: {
                    typeSpecifierList = child;
                    break;
                }
                case 114: {
                    typeDeclaratorList = child;
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(child);
                }
            }
        }
        if (typeDeclaratorList != null) {
            if (typeDeclaratorList.getChildCount() != 1) {
                throw new ParseException("Only one type declarator is allowed in the typealias target");
            }
            typeDeclarator = (CommonTree)typeDeclaratorList.getChild(0);
        }
        if (typeSpecifierList == null) {
            throw new ParseException("Cannot have a typealias with no specifiers");
        }
        CTFTrace trace = ((Param)param).fTrace;
        IDeclaration targetDeclaration = TypeDeclaratorParser.INSTANCE.parse(typeDeclarator, new TypeDeclaratorParser.Param(trace, typeSpecifierList, scope, identifierSB));
        if (identifierSB.length() > 0) {
            throw new ParseException("Identifier (" + identifierSB.toString() + ") not expected in the typealias target");
        }
        return targetDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

