/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;

public final class TypeSpecifierListNameParser
implements ICommonTreeParser {
    public static final TypeSpecifierListNameParser INSTANCE = new TypeSpecifierListNameParser();

    private TypeSpecifierListNameParser() {
    }

    @Override
    public StringBuilder parse(CommonTree typeSpecifier, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        StringBuilder sb = new StringBuilder();
        switch (typeSpecifier.getType()) {
            case 8: 
            case 10: 
            case 18: 
            case 19: 
            case 24: 
            case 31: 
            case 37: 
            case 38: 
            case 42: 
            case 45: 
            case 61: 
            case 63: 
            case 77: 
            case 79: {
                TypeSpecifierListNameParser.parseSimple(typeSpecifier, sb);
                break;
            }
            case 104: {
                TypeSpecifierListNameParser.parseStruct(typeSpecifier, sb);
                break;
            }
            case 121: {
                TypeSpecifierListNameParser.parseVariant(typeSpecifier, sb);
                break;
            }
            case 89: {
                TypeSpecifierListNameParser.parseEnum(typeSpecifier, sb);
                break;
            }
            case 98: 
            case 99: 
            case 103: {
                throw new ParseException("CTF type found in createTypeSpecifierString");
            }
            default: {
                throw TsdlUtils.childTypeError(typeSpecifier);
            }
        }
        return sb;
    }

    private static void parseEnum(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree enumName = (CommonTree)typeSpecifier.getFirstChildWithType(93);
        if (enumName == null) {
            throw new ParseException("nameless enum found in createTypeSpecifierString");
        }
        CommonTree enumNameIdentifier = (CommonTree)enumName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(enumNameIdentifier, sb);
    }

    private static void parseVariant(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree variantName = (CommonTree)typeSpecifier.getFirstChildWithType(123);
        if (variantName == null) {
            throw new ParseException("nameless variant found in createTypeSpecifierString");
        }
        CommonTree variantNameIdentifier = (CommonTree)variantName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(variantNameIdentifier, sb);
    }

    private static void parseSimple(CommonTree typeSpecifier, StringBuilder sb) {
        sb.append(typeSpecifier.getText());
    }

    private static void parseStruct(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree structName = (CommonTree)typeSpecifier.getFirstChildWithType(106);
        if (structName == null) {
            throw new ParseException("nameless struct found in createTypeSpecifierString");
        }
        CommonTree structNameIdentifier = (CommonTree)structName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(structNameIdentifier, sb);
    }
}

