/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.cpuusage;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CpuUsageStateProviderTest {
    private static final String CPU_USAGE_FILE = "testfiles/cpu_analysis.xml";
    private IKernelTrace fTrace;
    private KernelCpuUsageAnalysis fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(CPU_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        CpuUsageStateProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        this.fModule = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        Assert.assertNotNull((Object)this.fModule);
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        CpuUsageStateProviderTest.deleteSuppFiles((ITmfTrace)this.fTrace);
        this.fTrace.dispose();
    }

    @Test
    public void testAnalysisExecution() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fModule));
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testReturnedStateSystem() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((long)1L, (long)ss.getStartTime());
        Assert.assertEquals((long)25L, (long)ss.getCurrentEndTime());
        try {
            int cpusQuark = ss.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ss.getSubAttributes(cpusQuark, false);
            Assert.assertEquals((long)2L, (long)cpuQuarks.size());
            for (Integer cpuQuark : cpuQuarks) {
                Assert.assertEquals((long)3L, (long)ss.getSubAttributes(cpuQuark.intValue(), false).size());
            }
            ArrayList<@NonNull StateIntervalStub> intervals = new ArrayList<StateIntervalStub>();
            intervals.add(new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.nullValue()));
            intervals.add(new StateIntervalStub(20, 25, (ITmfStateValue)TmfStateValue.newValueLong((long)19L)));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, intervals, (String[])new String[]{"CPUs", "0", "2"});
            intervals.clear();
            intervals.add(new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()));
            intervals.add(new StateIntervalStub(5, 14, (ITmfStateValue)TmfStateValue.newValueLong((long)3L)));
            intervals.add(new StateIntervalStub(15, 25, (ITmfStateValue)TmfStateValue.newValueLong((long)8L)));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, intervals, (String[])new String[]{"CPUs", "1", "4"});
            intervals.clear();
            intervals.add(new StateIntervalStub(1, 24, (ITmfStateValue)TmfStateValue.nullValue()));
            intervals.add(new StateIntervalStub(25, 25, (ITmfStateValue)TmfStateValue.newValueLong((long)5L)));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, intervals, (String[])new String[]{"CPUs", "0", "3"});
            intervals.clear();
            intervals.add(new StateIntervalStub(1, 1, (ITmfStateValue)TmfStateValue.nullValue()));
            intervals.add(new StateIntervalStub(2, 9, (ITmfStateValue)TmfStateValue.newValueLong((long)1L)));
            intervals.add(new StateIntervalStub(10, 25, (ITmfStateValue)TmfStateValue.newValueLong((long)6L)));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, intervals, (String[])new String[]{"CPUs", "1", "3"});
            HashMap<@NonNull String @NonNull [], @NonNull TmfStateValue> map = new HashMap<String[], TmfStateValue>();
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "0", "1"}), TmfStateValue.newValueLong((long)0L));
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "0", "2"}), TmfStateValue.newValueLong((long)19L));
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "0", "3"}), TmfStateValue.newValueLong((long)5L));
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "1", "1"}), TmfStateValue.newValueLong((long)5L));
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "1", "3"}), TmfStateValue.newValueLong((long)6L));
            map.put(StateSystemTestUtils.makeAttribute((String[])new String[]{"CPUs", "1", "4"}), TmfStateValue.newValueLong((long)8L));
            StateSystemTestUtils.testValuesAtTime((ITmfStateSystem)ss, (long)25L, map);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUsageInRange() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("0/1", 0L);
        expected.put("0/2", 19L);
        expected.put("0/3", 5L);
        expected.put("1/1", 5L);
        expected.put("1/3", 6L);
        expected.put("1/4", 13L);
        expected.put("total", 48L);
        expected.put("total/1", 5L);
        expected.put("total/2", 19L);
        expected.put("total/3", 11L);
        expected.put("total/4", 13L);
        expected.put("0", 24L);
        expected.put("1", 24L);
        Map resultMap = this.fModule.getCpuUsageInRange(Collections.EMPTY_SET, 0L, 30L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 0L);
        expected.put("0/3", 3L);
        expected.put("1/1", 0L);
        expected.put("1/3", 0L);
        expected.put("1/4", 3L);
        expected.put("total", 6L);
        expected.put("total/1", 0L);
        expected.put("total/2", 0L);
        expected.put("total/3", 3L);
        expected.put("total/4", 3L);
        expected.put("0", 3L);
        expected.put("1", 3L);
        resultMap = this.fModule.getCpuUsageInRange(Collections.EMPTY_SET, 22L, 25L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 3L);
        expected.put("0/3", 0L);
        expected.put("1/1", 0L);
        expected.put("1/3", 1L);
        expected.put("1/4", 2L);
        expected.put("total", 6L);
        expected.put("total/1", 0L);
        expected.put("total/2", 3L);
        expected.put("total/3", 1L);
        expected.put("total/4", 2L);
        expected.put("0", 3L);
        expected.put("1", 3L);
        resultMap = this.fModule.getCpuUsageInRange(Collections.EMPTY_SET, 1L, 4L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 9L);
        expected.put("0/3", 0L);
        expected.put("1/1", 0L);
        expected.put("1/3", 5L);
        expected.put("1/4", 4L);
        expected.put("total", 18L);
        expected.put("total/1", 0L);
        expected.put("total/2", 9L);
        expected.put("total/3", 5L);
        expected.put("total/4", 4L);
        expected.put("0", 9L);
        expected.put("1", 9L);
        resultMap = this.fModule.getCpuUsageInRange(Collections.EMPTY_SET, 4L, 13L);
        Assert.assertEquals(expected, (Object)resultMap);
    }

    @Test
    public void testInRangeWithCpuSubset() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("0/1", 0L);
        expected.put("0/2", 9L);
        expected.put("0/3", 0L);
        expected.put("total/1", 0L);
        expected.put("total/2", 9L);
        expected.put("total/3", 0L);
        expected.put("0", 9L);
        expected.put("total", 9L);
        Map resultMap = this.fModule.getCpuUsageInRange(Collections.singleton(0), 4L, 13L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("1/1", 0L);
        expected.put("1/3", 5L);
        expected.put("1/4", 4L);
        expected.put("total/1", 0L);
        expected.put("total/3", 5L);
        expected.put("total/4", 4L);
        expected.put("1", 9L);
        expected.put("total", 9L);
        resultMap = this.fModule.getCpuUsageInRange((Set)ImmutableSet.of((Object)1, (Object)2), 4L, 13L);
        Assert.assertEquals(expected, (Object)resultMap);
    }

    @Test
    public void testRequirements() {
        IKernelTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        IKernelAnalysisEventLayout layout = trace.getKernelEventLayout();
        ImmutableSet expected = ImmutableSet.of((Object)layout.eventSchedSwitch());
        Set actual = StreamSupport.stream(this.fModule.getAnalysisRequirements().spliterator(), false).flatMap(req -> req.getValues().stream()).collect(Collectors.toSet());
        Assert.assertEquals((Object)expected, actual);
    }
}

