/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput.AbstractTestInputOutput;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestFactory;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputOutputDiskTest
extends AbstractTestInputOutput {
    private final IoTestCase fTestCase;

    public InputOutputDiskTest(String testName, IoTestCase test) {
        this.fTestCase = test;
    }

    @After
    public void tearDown() {
        super.deleteTrace();
    }

    @Override
    protected @NonNull InputOutputAnalysisModule setUp(String fileName) {
        InputOutputAnalysisModule module = super.setUp(fileName);
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        return module;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({IoTestFactory.SIMPLE_REQUESTS.getTraceFileName(), IoTestFactory.SIMPLE_REQUESTS}, {IoTestFactory.SIMPLE_NO_STATEDUMP.getTraceFileName(), IoTestFactory.SIMPLE_NO_STATEDUMP}, {IoTestFactory.TWO_DEVICES.getTraceFileName(), IoTestFactory.TWO_DEVICES});
    }

    private static Disk getDisk(@NonNull InputOutputAnalysisModule module, Integer deviceId) {
        return InputOutputInformationProvider.getDisks((InputOutputAnalysisModule)module).stream().filter(d -> d.getDevideId().equals(deviceId)).findFirst().get();
    }

    @Test
    public void testSectorsAt() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        for (Integer deviceId : this.fTestCase.getSectorCount().keySet()) {
            Disk disk = InputOutputDiskTest.getDisk(module, deviceId);
            Assert.assertNotNull((Object)disk);
            for (IoTestCase.SectorCountInfo info : this.fTestCase.getSectorCount().get((Object)deviceId)) {
                long sectorsAt = disk.getSectorsAt(info.getTimestamp(), info.getType());
                Assert.assertEquals((String)("Sectors at " + info.getTimestamp() + " for type " + info.getType()), (long)info.getNbSectors(), (long)sectorsAt);
            }
        }
    }

    @Test
    public void testDeviceStrings() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        for (Map.Entry<Integer, IoTestCase.DiskInfo> deviceInfo : this.fTestCase.getDiskInfo().entrySet()) {
            Integer deviceId = deviceInfo.getKey();
            IoTestCase.DiskInfo diskInfo = deviceInfo.getValue();
            Disk disk = InputOutputDiskTest.getDisk(module, deviceId);
            Assert.assertNotNull((Object)disk);
            Assert.assertEquals((String)("Device ID string for " + deviceId), (Object)diskInfo.getDeviceString(), (Object)disk.getDeviceIdString());
            Assert.assertEquals((String)("Disk name string for " + deviceId), (Object)diskInfo.getDeviceName(), (Object)disk.getDiskName());
            Assert.assertEquals((String)("Disk activity for " + deviceId), (Object)diskInfo.hasActivity(), (Object)disk.hasActivity());
        }
    }
}

