/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput;

import java.util.Arrays;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput.AbstractTestInputOutput;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestFactory;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputOutputStateProviderTest
extends AbstractTestInputOutput {
    private final LinuxTestCase fTestCase;

    public InputOutputStateProviderTest(String testName, LinuxTestCase test) {
        this.fTestCase = test;
    }

    @After
    public void tearDown() {
        super.deleteTrace();
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({IoTestFactory.SIMPLE_REQUESTS.getTraceFileName(), IoTestFactory.SIMPLE_REQUESTS}, {IoTestFactory.SIMPLE_NO_STATEDUMP.getTraceFileName(), IoTestFactory.SIMPLE_NO_STATEDUMP}, {IoTestFactory.REQUESTS_MERGE.getTraceFileName(), IoTestFactory.REQUESTS_MERGE}, {IoTestFactory.REQUESTS_MISSING.getTraceFileName(), IoTestFactory.REQUESTS_MISSING}, {IoTestFactory.TWO_DEVICES.getTraceFileName(), IoTestFactory.TWO_DEVICES}, {IoTestFactory.SYSCALL_READ.getTraceFileName(), IoTestFactory.SYSCALL_READ}, {IoTestFactory.SYSCALL_WRITE.getTraceFileName(), IoTestFactory.SYSCALL_WRITE}, {IoTestFactory.SYSCALLS_KERNEL.getTraceFileName(), IoTestFactory.SYSCALLS_KERNEL});
    }

    @Test
    public void testAnalysisExecution() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        Assert.assertNull((Object)module.getStateSystem());
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)module));
        Assert.assertNotNull((Object)module.getStateSystem());
    }

    @Test
    public void testStateProviderIntervalData() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        Assert.assertNotNull((Object)module);
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        for (LinuxTestCase.IntervalInfo info : this.fTestCase.getTestIntervals()) {
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, info.getIntervals(), (String[])info.getAttributePath());
        }
    }

    @Test
    public void testStateProviderPunctualData() {
        InputOutputAnalysisModule module = this.setUp(this.fTestCase.getTraceFileName());
        Assert.assertNotNull((Object)module);
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        for (LinuxTestCase.PunctualInfo info : this.fTestCase.getPunctualTestData()) {
            StateSystemTestUtils.testValuesAtTime((ITmfStateSystem)ss, (long)info.getTimestamp(), info.getValues());
        }
    }
}

