/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernel;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.kernel.KernelAnalysisTestFactory;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KernelThreadInformationProviderTest {
    private static final @NonNull LinuxTestCase KERNEL_TEST_CASE = KernelAnalysisTestFactory.KERNEL_SCHED;
    private ITmfTrace fTrace;
    private KernelAnalysisModule fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlKernelTraceStub trace = KERNEL_TEST_CASE.getKernelTrace();
        KernelThreadInformationProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        this.fModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        KernelThreadInformationProviderTest.deleteSuppFiles(this.fTrace);
        this.fTrace.dispose();
    }

    @Test
    public void testGetThreadQuarks() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Collection threadIds = KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)module);
        Assert.assertEquals((Object)ImmutableSet.of((Object)10, (Object)11, (Object)20, (Object)21, (Object)30, (Object)100, (Object[])new Integer[0]), (Object)threadIds);
    }

    @Test
    public void testGetThreadOnCpu() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)-1L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)90L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)2L, (long)20L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)-1L, (long)20L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)4L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)15L);
        Assert.assertNull((Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)15L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)29L);
        Assert.assertEquals((Object)20, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)30L);
        Assert.assertEquals((Object)21, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)59L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)59L);
        Assert.assertEquals((Object)30, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)0L, (long)60L);
        Assert.assertEquals((Object)11, (Object)tid);
        tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)1L, (long)60L);
        Assert.assertEquals((Object)21, (Object)tid);
    }

    @Test
    public void testGetPpid() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)-1L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)90L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)-4, (long)20L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)12, (long)20L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)10, (long)20L);
        Assert.assertEquals((Object)0, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)30, (long)60L);
        Assert.assertEquals((Object)0, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)4L);
        Assert.assertNull((Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)11, (long)5L);
        Assert.assertEquals((Object)10, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)21, (long)25L);
        Assert.assertEquals((Object)20, (Object)ppid);
        ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)21, (long)70L);
        Assert.assertEquals((Object)20, (Object)ppid);
    }

    @Test
    public void testGetExecutableName() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        String execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)101);
        Assert.assertNull((Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)-2);
        Assert.assertNull((Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)20);
        Assert.assertEquals((Object)"proc20", (Object)execName);
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)21);
        Assert.assertEquals((Object)"proc21", (Object)execName);
    }

    private static void testIntervals(String info, List<ITmfStateInterval> intervals, ITmfStateValue[] values) {
        Assert.assertEquals((String)(String.valueOf(info) + " interval count"), (long)values.length, (long)intervals.size());
        int i = 0;
        while (i < values.length) {
            Assert.assertEquals((String)(String.valueOf(info) + " interval " + i), (Object)values[i], (Object)intervals.get(i).getStateValue());
            ++i;
        }
    }

    @Test
    public void testGetStatusIntervalsForThread() {
        KernelAnalysisModule module = (KernelAnalysisModule)NonNullUtils.checkNotNull((Object)this.fModule);
        NullProgressMonitor monitor = new NullProgressMonitor();
        Integer process21 = 21;
        Integer process20 = 20;
        List intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)-15L, (long)-5L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)90L, (long)1500000000L, (long)50L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)-1, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)0, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)intervals.isEmpty());
        ITmfStateValue[] values = new ITmfStateValue[]{TmfStateValue.nullValue(), StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE, StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE, StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE, StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [0,70,3]", intervals, values);
        ITmfStateValue[] values2 = new ITmfStateValue[]{TmfStateValue.nullValue(), StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE, StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)1L, (long)70L, (long)30L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [0,70,30]", intervals, values2);
        ITmfStateValue[] values3 = new ITmfStateValue[]{StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE, StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process21, (long)25L, (long)50L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 21 [25,50,3]", intervals, values3);
        ITmfStateValue[] values4 = new ITmfStateValue[]{TmfStateValue.nullValue(), StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE, StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE, StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)0L, (long)70L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [0,70,3]", intervals, values4);
        ITmfStateValue[] values5 = new ITmfStateValue[]{TmfStateValue.nullValue(), StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)1L, (long)70L, (long)30L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [0,70,30]", intervals, values5);
        ITmfStateValue[] values6 = new ITmfStateValue[]{StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE, StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)25L, (long)50L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [25,50,3]", intervals, values6);
        ITmfStateValue[] values7 = new ITmfStateValue[]{StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE};
        intervals = KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)module, (Integer)process20, (long)80L, (long)85L, (long)3L, (IProgressMonitor)monitor);
        KernelThreadInformationProviderTest.testIntervals("tid 20 [80,85,3]", intervals, values7);
    }
}

