/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.junit.Assert;

public class LinuxTestCase {
    private final String fTraceFile;

    public LinuxTestCase(String filename) {
        this.fTraceFile = filename;
    }

    public String getTraceFileName() {
        return (String)NonNullUtils.checkNotNull((Object)FilenameUtils.getName((String)this.fTraceFile));
    }

    public TmfXmlKernelTraceStub getKernelTrace() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(this.fTraceFile);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        return trace;
    }

    public Set<IntervalInfo> getTestIntervals() {
        return Collections.EMPTY_SET;
    }

    public Set<PunctualInfo> getPunctualTestData() {
        return Collections.EMPTY_SET;
    }

    public static class IntervalInfo {
        private final String[] fAttributePath;
        private final List<ITmfStateInterval> fIntervals;

        public IntervalInfo(List<ITmfStateInterval> intervals, String ... attributePath) {
            this.fAttributePath = attributePath;
            this.fIntervals = intervals;
        }

        public String[] getAttributePath() {
            return this.fAttributePath;
        }

        public List<ITmfStateInterval> getIntervals() {
            return this.fIntervals;
        }
    }

    public static class PunctualInfo {
        private final long fTs;
        private final Map<String[], ITmfStateValue> fValueMap;

        public PunctualInfo(long ts) {
            this.fTs = ts;
            this.fValueMap = new HashMap<String[], ITmfStateValue>();
        }

        public long getTimestamp() {
            return this.fTs;
        }

        public Map<String[], ITmfStateValue> getValues() {
            return this.fValueMap;
        }

        public void addValue(String[] key, ITmfStateValue value) {
            this.fValueMap.put(key, value);
        }
    }
}

