/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.LinuxTestCase;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.inputoutput.IoTestCase;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;

public final class IoTestFactory {
    private static final String DEVICE_ID = "8388624";
    private static final String DEVICE_NAME = "sda";
    private static final String SECOND_DEVICE_ID = "8388608";
    public static final IoTestCase SIMPLE_REQUESTS = new IoTestCase("io_analysis.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(10, 24, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(25, 26, (ITmfStateValue)TmfStateValue.newValueInt((int)2)), (Object)new StateIntervalStub(27, 28, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(29, 39, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(40, 49, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(50, 60, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(10, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(20, 26, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(27, 28, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(29, 29, (ITmfStateValue)TmfStateValue.newValueInt((int)2)), (Object)new StateIntervalStub(30, 34, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(35, 49, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(50, 59, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(60, 60, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "driverqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 59, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(60, 60, (ITmfStateValue)TmfStateValue.newValueInt((int)256)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(20, 29, (ITmfStateValue)TmfStateValue.newValueInt((int)8)), (Object)new StateIntervalStub(30, 34, (ITmfStateValue)TmfStateValue.newValueInt((int)16)), (Object)new StateIntervalStub(35, 60, (ITmfStateValue)TmfStateValue.newValueInt((int)24)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 60, (ITmfStateValue)TmfStateValue.newValueString((String)IoTestFactory.DEVICE_NAME)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            HashSet<LinuxTestCase.PunctualInfo> info = new HashSet<LinuxTestCase.PunctualInfo>();
            LinuxTestCase.PunctualInfo oneInfo = new LinuxTestCase.PunctualInfo(5L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)444L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(10L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)444L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(20L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(25L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)111L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)222L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(27L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)222L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)111L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(29L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)111L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)222L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)1));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(30L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)222L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)1));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(35L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "1", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(40L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)444L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)256));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(50L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)444L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)256));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(60L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            info.add(oneInfo);
            return info;
        }

        @Override
        public Multimap<Integer, IoTestCase.SectorCountInfo> getSectorCount() {
            Integer deviceId = Integer.parseInt(IoTestFactory.DEVICE_ID);
            HashMultimap map = HashMultimap.create();
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(5L, IoOperationType.READ, 0L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(50L, IoOperationType.READ, 0L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(55L, IoOperationType.READ, 128L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(60L, IoOperationType.READ, 256L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(5L, IoOperationType.WRITE, 0L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(15L, IoOperationType.WRITE, 4L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(20L, IoOperationType.WRITE, 8L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(27L, IoOperationType.WRITE, 8L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(28L, IoOperationType.WRITE, 10L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(29L, IoOperationType.WRITE, 13L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(30L, IoOperationType.WRITE, 17L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(35L, IoOperationType.WRITE, 24L));
            map.put((Object)deviceId, (Object)new IoTestCase.SectorCountInfo(60L, IoOperationType.WRITE, 24L));
            return map;
        }

        @Override
        public Map<Integer, IoTestCase.DiskInfo> getDiskInfo() {
            TreeMap<Integer, IoTestCase.DiskInfo> map = new TreeMap<Integer, IoTestCase.DiskInfo>();
            Integer deviceId = Integer.parseInt(IoTestFactory.DEVICE_ID);
            map.put(deviceId, new IoTestCase.DiskInfo("8,16", IoTestFactory.DEVICE_NAME, true));
            return map;
        }
    };
    public static final IoTestCase SIMPLE_NO_STATEDUMP = new IoTestCase("io_nostatedump.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(10, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(10, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "driverqueue_length"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }

        @Override
        public Map<Integer, IoTestCase.DiskInfo> getDiskInfo() {
            TreeMap<Integer, IoTestCase.DiskInfo> map = new TreeMap<Integer, IoTestCase.DiskInfo>();
            Integer deviceId = Integer.parseInt(IoTestFactory.DEVICE_ID);
            map.put(deviceId, new IoTestCase.DiskInfo("8,16", "8,16", true));
            return map;
        }
    };
    public static final LinuxTestCase SYSCALL_READ = new LinuxTestCase("io_syscall_read.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(10, 24, (ITmfStateValue)TmfStateValue.newValueInt((int)8)), (Object)new StateIntervalStub(25, 50, (ITmfStateValue)TmfStateValue.newValueInt((int)44)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "2", "bytes_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 49, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(50, 50, (ITmfStateValue)TmfStateValue.newValueInt((int)8)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "5", "bytes_read"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }
    };
    public static final LinuxTestCase SYSCALL_WRITE = new LinuxTestCase("io_syscall_write.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(10, 29, (ITmfStateValue)TmfStateValue.newValueInt((int)16)), (Object)new StateIntervalStub(30, 39, (ITmfStateValue)TmfStateValue.newValueInt((int)26)), (Object)new StateIntervalStub(40, 50, (ITmfStateValue)TmfStateValue.newValueInt((int)36)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "2", "bytes_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 29, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(30, 49, (ITmfStateValue)TmfStateValue.newValueInt((int)32)), (Object)new StateIntervalStub(50, 50, (ITmfStateValue)TmfStateValue.newValueInt((int)96)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "5", "bytes_written"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }
    };
    public static final LinuxTestCase REQUESTS_MERGE = new LinuxTestCase("io_req_merge.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(10, 14, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(15, 34, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(35, 39, (ITmfStateValue)TmfStateValue.newValueInt((int)2)), (Object)new StateIntervalStub(40, 41, (ITmfStateValue)TmfStateValue.newValueInt((int)3)), (Object)new StateIntervalStub(42, 44, (ITmfStateValue)TmfStateValue.newValueInt((int)2)), (Object)new StateIntervalStub(45, 49, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(50, 54, (ITmfStateValue)TmfStateValue.newValueInt((int)2)), (Object)new StateIntervalStub(55, 59, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(60, 65, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(10, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(20, 59, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(60, 64, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(65, 65, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "driverqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 64, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(65, 65, (ITmfStateValue)TmfStateValue.newValueInt((int)40)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(20, 65, (ITmfStateValue)TmfStateValue.newValueInt((int)16)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_written"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            HashSet<LinuxTestCase.PunctualInfo> info = new HashSet<LinuxTestCase.PunctualInfo>();
            LinuxTestCase.PunctualInfo oneInfo = new LinuxTestCase.PunctualInfo(5L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)444L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(7L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)436L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)16));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(10L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)436L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)16));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(15L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)292L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.WRITING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)436L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)16));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(20L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(35L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)292L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(40L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)292L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)300L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)16));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(42L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)292L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)24));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(45L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)1));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)32));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(50L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)316L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)8));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)32));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(55L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)1));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)40));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "merged_in"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "merged_in"}), (ITmfStateValue)TmfStateValue.newValueInt((int)0));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(60L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "1", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Waiting_queue", "2", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), StateValues.READING_REQUEST_VALUE);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.newValueLong((long)284L));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.newValueInt((int)40));
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.newValueInt((int)1));
            info.add(oneInfo);
            oneInfo = new LinuxTestCase.PunctualInfo(65L);
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Current_request"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "Request_size"}), (ITmfStateValue)TmfStateValue.nullValue());
            oneInfo.addValue(StateSystemTestUtils.makeAttribute((String[])new String[]{"Disks", IoTestFactory.DEVICE_ID, "Driver_queue", "0", "issued_from"}), (ITmfStateValue)TmfStateValue.nullValue());
            info.add(oneInfo);
            return info;
        }
    };
    public static final LinuxTestCase REQUESTS_MISSING = new LinuxTestCase("io_missing.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 14, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(15, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(20, 34, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(35, 39, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(40, 49, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(50, 59, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(60, 79, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(80, 99, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(100, 119, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(120, 140, (ITmfStateValue)TmfStateValue.newValueInt((int)1)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(10, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(20, 24, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(25, 39, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(40, 44, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(45, 59, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(60, 64, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(65, 99, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(100, 140, (ITmfStateValue)TmfStateValue.newValueInt((int)1)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "driverqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 29, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(30, 44, (ITmfStateValue)TmfStateValue.newValueInt((int)16)), (Object)new StateIntervalStub(45, 64, (ITmfStateValue)TmfStateValue.newValueInt((int)56)), (Object)new StateIntervalStub(65, 140, (ITmfStateValue)TmfStateValue.newValueInt((int)96)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(10, 24, (ITmfStateValue)TmfStateValue.newValueInt((int)8)), (Object)new StateIntervalStub(25, 139, (ITmfStateValue)TmfStateValue.newValueInt((int)24)), (Object)new StateIntervalStub(140, 140, (ITmfStateValue)TmfStateValue.newValueInt((int)32)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_written"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }
    };
    public static final IoTestCase TWO_DEVICES = new IoTestCase("io_two_devices.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(10, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(5, 9, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(10, 19, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "driverqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 20, (ITmfStateValue)TmfStateValue.nullValue()));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)8)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.DEVICE_ID, "sectors_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 7, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(8, 11, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(12, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.SECOND_DEVICE_ID, "waitingqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 7, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(8, 11, (ITmfStateValue)TmfStateValue.newValueInt((int)0)), (Object)new StateIntervalStub(12, 17, (ITmfStateValue)TmfStateValue.newValueInt((int)1)), (Object)new StateIntervalStub(18, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)0)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.SECOND_DEVICE_ID, "driverqueue_length"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 17, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(18, 20, (ITmfStateValue)TmfStateValue.newValueInt((int)16)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.SECOND_DEVICE_ID, "sectors_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 20, (ITmfStateValue)TmfStateValue.nullValue()));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Disks", IoTestFactory.SECOND_DEVICE_ID, "sectors_written"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }

        @Override
        public Map<Integer, IoTestCase.DiskInfo> getDiskInfo() {
            TreeMap<Integer, IoTestCase.DiskInfo> map = new TreeMap<Integer, IoTestCase.DiskInfo>();
            Integer deviceId = Integer.parseInt(IoTestFactory.DEVICE_ID);
            map.put(deviceId, new IoTestCase.DiskInfo("8,16", IoTestFactory.DEVICE_NAME, true));
            deviceId = Integer.parseInt(IoTestFactory.SECOND_DEVICE_ID);
            map.put(deviceId, new IoTestCase.DiskInfo("8,0", "sdb", true));
            map.put(0x800001, new IoTestCase.DiskInfo("8,1", "sdb1", false));
            return map;
        }
    };
    public static final LinuxTestCase SYSCALLS_KERNEL = new LinuxTestCase("io_full_kernel.xml"){

        @Override
        public Set<LinuxTestCase.IntervalInfo> getTestIntervals() {
            HashSet<LinuxTestCase.IntervalInfo> info = new HashSet<LinuxTestCase.IntervalInfo>();
            ImmutableList intervals = ImmutableList.of((Object)new StateIntervalStub(1, 29, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(30, 45, (ITmfStateValue)TmfStateValue.newValueInt((int)20)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "1", "bytes_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 45, (ITmfStateValue)TmfStateValue.nullValue()));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "1", "bytes_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(10, 45, (ITmfStateValue)TmfStateValue.newValueInt((int)8)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "2", "bytes_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 45, (ITmfStateValue)TmfStateValue.nullValue()));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "2", "bytes_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 34, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(35, 45, (ITmfStateValue)TmfStateValue.newValueInt((int)36)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "3", "bytes_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 39, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(40, 45, (ITmfStateValue)TmfStateValue.newValueInt((int)64)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "3", "bytes_written"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 45, (ITmfStateValue)TmfStateValue.nullValue()));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "4", "bytes_read"));
            intervals = ImmutableList.of((Object)new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()), (Object)new StateIntervalStub(10, 45, (ITmfStateValue)TmfStateValue.newValueInt((int)16)));
            info.add(new LinuxTestCase.IntervalInfo((List<ITmfStateInterval>)intervals, "Threads", "4", "bytes_written"));
            return info;
        }

        @Override
        public Set<LinuxTestCase.PunctualInfo> getPunctualTestData() {
            return new HashSet<LinuxTestCase.PunctualInfo>();
        }
    };

    private IoTestFactory() {
    }
}

