/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.tests.CtfCoreTestPlugin;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.junit.Assert;
import org.junit.Test;

public class IOstructgenTest {
    private static final String metadataDecs = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\n";
    private static final String environmentMD = "env {\n    hostname = \"DemoSystem\";\n    vpid = 1337;\n    procname = \"demo\";\n    domain = \"autogenerated\";\n    tracer_name = \"tmf\";\n    tracer_major = 2;\n    tracer_minor = 0x01;\n    tracer_patchlevel = 0;\n};\n\n";
    private static final String clockMD = "clock {\n    name = monotonic;\n    uuid = \"cbf9f42e-9be7-4798-a96f-11db556e2ebb\";\n    description = \"Monotonic Clock\";\n    freq = 1000000000; /* Frequency, in Hz */\n    /* clock value offset from Epoch is: offset * (1/freq) */\n    offset = 1350310657466295832;\n};\n\n";
    private static final String ctfStart = "typealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\n";
    private static final String ctfHeaders = "struct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\n";
    private static final String ctfBody = "stream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\n";
    private static final String enumMd = "typealias integer { size = 32; align = 8; signed = false; } := int;\ntypealias enum { ONE = 0, a,b,c=10, d} := useless_enum;\nstruct useless{ \n    enum : uint8_t { A=0, \"B\",} enum3;\n    useless_enum enum2;    enum { C, D, E } enum4;\n    uint16_t val;\n} ;\n\nevent {\n   name = \"enumEvent\";\n   id = 6;\n   stream_id = 0;\n   loglevel = 5;\n   fields := struct{\n       uint16_t _some_field;\n       enum {A, B, C = 3 , } _other_enum;\n   };\n};\n\n";
    private static final String contextMD = "event {\n   name = \"someOtherEvent\";\n   id = 5;\n   stream_id = 0;\n   loglevel = 5;\n   context := struct{\n       uint16_t _someContext;\n   };\n   fields := struct{\n       uint16_t _somefield;\n   };\n};\n \n";
    private static final String simpleTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\n";
    private static final String enumTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\ntypealias integer { size = 32; align = 8; signed = false; } := int;\ntypealias enum { ONE = 0, a,b,c=10, d} := useless_enum;\nstruct useless{ \n    enum : uint8_t { A=0, \"B\",} enum3;\n    useless_enum enum2;    enum { C, D, E } enum4;\n    uint16_t val;\n} ;\n\nevent {\n   name = \"enumEvent\";\n   id = 6;\n   stream_id = 0;\n   loglevel = 5;\n   fields := struct{\n       uint16_t _some_field;\n       enum {A, B, C = 3 , } _other_enum;\n   };\n};\n\n";
    private static final String clockTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\nclock {\n    name = monotonic;\n    uuid = \"cbf9f42e-9be7-4798-a96f-11db556e2ebb\";\n    description = \"Monotonic Clock\";\n    freq = 1000000000; /* Frequency, in Hz */\n    /* clock value offset from Epoch is: offset * (1/freq) */\n    offset = 1350310657466295832;\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\n";
    private static final String envTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\nenv {\n    hostname = \"DemoSystem\";\n    vpid = 1337;\n    procname = \"demo\";\n    domain = \"autogenerated\";\n    tracer_name = \"tmf\";\n    tracer_major = 2;\n    tracer_minor = 0x01;\n    tracer_patchlevel = 0;\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\n";
    private static final String contextTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\nenv {\n    hostname = \"DemoSystem\";\n    vpid = 1337;\n    procname = \"demo\";\n    domain = \"autogenerated\";\n    tracer_name = \"tmf\";\n    tracer_major = 2;\n    tracer_minor = 0x01;\n    tracer_patchlevel = 0;\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\nevent {\n   name = \"someOtherEvent\";\n   id = 5;\n   stream_id = 0;\n   loglevel = 5;\n   context := struct{\n       uint16_t _someContext;\n   };\n   fields := struct{\n       uint16_t _somefield;\n   };\n};\n \n";
    private static final String allDressedTSDL = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 64; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\ntypealias integer { size = 32; align = 1; signed = true; base = decimal; } := int32_t;\ntypealias integer { size = 31; align = 1; signed = true; base = dec; } := int31_t;\ntypealias integer { size = 30; align = 1; signed = true; base = d; } := int30_t;\ntypealias integer { size = 29; align = 1; signed = true; base = i; } := int29_t;\ntypealias integer { size = 28; align = 1; signed = true; base = u; } := int28_t;\ntypealias integer { size = 27; align = 1; signed = true; base = hexadecimal; } := int27_t;\ntypealias integer { size = 26; align = 1; signed = true; base = hex; } := int26_t;\ntypealias integer { size = 25; align = 1; signed = true; base = x; } := int25_t;\ntypealias integer { size = 24; align = 1; signed = true; base = X; } := int24_t;\ntypealias integer { size = 23; align = 1; signed = true; base = p; } := int23_t;\ntypealias integer { size = 22; align = 1; signed = true; base = 16; } := int22_t;\ntypealias integer { size = 21; align = 1; signed = true; base = oct; } := int21_t;\ntypealias integer { size = 20; align = 1; signed = true; base = b; } := int20_t;\ntypealias integer { size = 19; align = 1; signed = true; base = octal; } := int19_t;\ntypealias integer { size = 18; align = 1; signed = true; base = o; } := int18_t;\ntypealias integer { size = 17; align = 1; signed = true; base = binary; } := int17_t;\n\ntrace {\n    major = 1;\n    minor = 8;\n    uuid = \"b04d391b-e736-44c1-8d89-4bb438857f8d\";\n    byte_order = le;\n    packet.header := struct {\n        uint32_t magic;\n        uint8_t  uuid[16];\n        uint32_t stream_id;\n    };\n};\n\nenv {\n    hostname = \"DemoSystem\";\n    vpid = 1337;\n    procname = \"demo\";\n    domain = \"autogenerated\";\n    tracer_name = \"tmf\";\n    tracer_major = 2;\n    tracer_minor = 0x01;\n    tracer_patchlevel = 0;\n};\n\nclock {\n    name = monotonic;\n    uuid = \"cbf9f42e-9be7-4798-a96f-11db556e2ebb\";\n    description = \"Monotonic Clock\";\n    freq = 1000000000; /* Frequency, in Hz */\n    /* clock value offset from Epoch is: offset * (1/freq) */\n    offset = 1350310657466295832;\n};\n\ntypealias integer {\n    size = 27; align = 1; signed = false;\n    map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n    size = 32; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n    size = 64; align = 8; signed = false;\n    map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n    uint64_clock_monotonic_t timestamp_begin;\n    uint64_clock_monotonic_t timestamp_end;\n    uint64_t content_size;\n    uint64_t packet_size;\n    unsigned long events_discarded;\n    uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n    enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n    variant <id> {\n        struct {\n            uint27_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstruct event_header_large {\n    enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n    variant <id> {\n        struct {\n            uint32_clock_monotonic_t timestamp;\n        } compact;\n        struct {\n            uint32_t id;\n            uint64_clock_monotonic_t timestamp;\n        } extended;\n    } v;\n} align(8);\n\nstream {\n    id = 0;\n    event.header := struct event_header_compact;\n    packet.context := struct packet_context;\n    event.context := struct {\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 16; } _ip;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo3:done\";\n    id = 0;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:starting\";\n    id = 1;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:starting\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo:done\";\n    id = 2;\n    stream_id = 0;\n    loglevel = 2;\n    model.emf.uri = \"http://example.com/path_to_model?q=ust_tests_demo:done\";\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _value;\n    };\n};\n\nevent {\n    name = \"ust_tests_demo2:loop\";\n    id = 3;\n    stream_id = 0;\n    loglevel = 4;\n    fields := struct {\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _intfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; } _intfield2;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _longfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; byte_order = be; } _netintfield;\n        integer { size = 32; align = 8; signed = 1; encoding = none; base = 16; byte_order = be; } _netintfieldhex;\n        integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _arrfield1[3];\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _arrfield2[10];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield1_length;\n        integer { size = 8; align = 8; signed = 1; encoding = none; base = 10; } _seqfield1[ __seqfield1_length ];\n        integer { size = 64; align = 8; signed = 0; encoding = none; base = 10; } __seqfield2_length;\n        integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _seqfield2[ __seqfield2_length ];\n        string _stringfield;\n        floating_point { exp_dig = 8; mant_dig = 24; align = 8; } _floatfield;\n        floating_point { exp_dig = 11; mant_dig = 53; align = 8; } _doublefield;\n    };\n};\n\ntypealias integer { size = 32; align = 8; signed = false; } := int;\ntypealias enum { ONE = 0, a,b,c=10, d} := useless_enum;\nstruct useless{ \n    enum : uint8_t { A=0, \"B\",} enum3;\n    useless_enum enum2;    enum { C, D, E } enum4;\n    uint16_t val;\n} ;\n\nevent {\n   name = \"enumEvent\";\n   id = 6;\n   stream_id = 0;\n   loglevel = 5;\n   fields := struct{\n       uint16_t _some_field;\n       enum {A, B, C = 3 , } _other_enum;\n   };\n};\n\n";
    static final String tempTraceDir = String.valueOf(CtfCoreTestPlugin.getTemporaryDirPath()) + File.separator + "tempTrace";
    private static final int DATA_SIZE = 4096;
    private static final int HEADER_SIZE = 68;
    private static final int PACKET_SIZE = 4676;
    private CTFTrace trace;

    private static void deltree(File f) {
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File elem = fileArray[n2];
            if (elem.isDirectory()) {
                IOstructgenTest.deltree(elem);
            }
            elem.delete();
            ++n2;
        }
        f.delete();
    }

    private static void createDummyTrace(String metadata) {
        File dir = new File(tempTraceDir);
        if (dir.exists()) {
            IOstructgenTest.deltree(dir);
        }
        dir.mkdirs();
        File metadataFile = new File(String.valueOf(tempTraceDir) + "/metadata");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fw = new FileWriter(metadataFile);){
                fw.write(metadata);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] magicLE = new byte[]{-63, 31, -4, -63};
        byte[] uuid = new byte[]{-80, 77, 57, 27, -25, 54, 68, -63, -115, -119, 75, -76, 56, -123, 127, -115};
        Event ev = new Event(2, 2);
        int nbEvents = 4096 / ev.getSize() - 1;
        int contentSize = (nbEvents * ev.getSize() + 68) * 8;
        ByteBuffer data = ByteBuffer.allocate(4676);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.clear();
        data.put(magicLE);
        data.put(uuid);
        data.putInt(0);
        data.putLong(42240L);
        data.putLong(nbEvents * 65536 + 42406);
        data.putLong(contentSize);
        data.putLong(37408L);
        data.putLong(0L);
        data.putInt(0);
        int i = 0;
        while (i < nbEvents) {
            ev.setEventTimestamp(i * 65536 + 42405);
            ev.setEventContent(i);
            ev.writeEvent(data);
            ++i;
        }
        data.flip();
        File dummyFile = new File(String.valueOf(tempTraceDir) + "/dummyChan");
        try {
            Throwable throwable = null;
            Object var11_17 = null;
            try (FileOutputStream fos = new FileOutputStream(dummyFile);){
                fos.getChannel().write(data);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void TSDLSimpleTest() throws CTFException {
        IOstructgenTest.createDummyTrace(simpleTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
    }

    @Test
    public void TSDLEnvironmentTest() throws CTFException {
        IOstructgenTest.createDummyTrace(envTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
    }

    @Test
    public void TSDLEnumTest() throws CTFException {
        IOstructgenTest.createDummyTrace(enumTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
    }

    @Test
    public void TSDLClockTest() throws CTFException {
        IOstructgenTest.createDummyTrace(clockTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
    }

    @Test
    public void TSDLContextTest() throws CTFException {
        IOstructgenTest.createDummyTrace(contextTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
    }

    @Test
    public void TSDLAllTest() throws CTFException {
        IOstructgenTest.createDummyTrace(allDressedTSDL);
        this.trace = new CTFTrace(tempTraceDir);
        Assert.assertNotNull((Object)this.trace);
        ArrayList eventDeclarations = new ArrayList(this.trace.getEventDeclarations(Long.valueOf(0L)));
        EventDeclaration eventDeclaration = (EventDeclaration)eventDeclarations.get(2);
        Assert.assertEquals((Object)"http://example.com/path_to_model?q=ust_tests_demo:done", (Object)eventDeclaration.getCustomAttribute("model.emf.uri"));
    }

    private static class Event {
        private static final int EVENT_SIZE = 16;
        private int eventId;
        private int eventTimestamp;
        private int eventContent;

        public Event(int id, int content) {
            this.eventId = id;
            this.eventTimestamp = 0;
            this.eventContent = content;
        }

        public void setEventTimestamp(int eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        public void setEventContent(int eventContent) {
            this.eventContent = eventContent;
        }

        public void writeEvent(ByteBuffer data) {
            int timeId = this.eventTimestamp << 5;
            data.putInt(timeId |= this.eventId & 0x1F);
            long ip = 275766408052224L + (long)(data.position() / this.getSize() & 0xF);
            data.putLong(ip);
            data.putInt(this.eventContent);
        }

        public int getSize() {
            return 16;
        }
    }
}

