/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariantDeclarationTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private VariantDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = new VariantDeclaration();
    }

    private static IDefinitionScope createDefinitionScope() throws CTFException {
        StructDeclaration declaration = new StructDeclaration(8L);
        VariantDeclaration variantDeclaration = new VariantDeclaration();
        variantDeclaration.addField("a", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        variantDeclaration.addField("b", (IDeclaration)IntegerDeclaration.INT_32L_DECL);
        variantDeclaration.setTag("a");
        EnumDeclaration enumDeclaration = new EnumDeclaration(IntegerDeclaration.UINT_8_DECL);
        enumDeclaration.add(0L, 1L, "a");
        enumDeclaration.add(2L, 2L, "b");
        declaration.addField("tag", (IDeclaration)enumDeclaration);
        declaration.addField("variant", (IDeclaration)variantDeclaration);
        EnumDefinition tagDef = new EnumDefinition(enumDeclaration, null, "tag", new IntegerDefinition(IntegerDeclaration.UINT_8_DECL, null, "test", 0L));
        VariantDefinition variantDefinition = new VariantDefinition(variantDeclaration, (IDefinitionScope)CtfTestTraceUtils.getTrace(testTrace), "tag", "tag", (Definition)new StringDefinition(StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8), null, "f", "tag"));
        StructDefinition definitionScope = new StructDefinition(declaration, (IDefinitionScope)variantDefinition, "", new Definition[]{tagDef, variantDefinition});
        return definitionScope;
    }

    @Test
    public void testVariantDeclaration() {
        Assert.assertNotNull((Object)this.fixture);
        Assert.assertEquals((Object)false, (Object)this.fixture.isTagged());
        String left = "[declaration] variant[";
        Assert.assertEquals((Object)left, (Object)this.fixture.toString().substring(0, left.length()));
    }

    @Test
    public void testAddField() {
        this.fixture.setTag("");
        String tag = "";
        StringDeclaration declaration = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        this.fixture.addField(tag, (IDeclaration)declaration);
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        this.fixture.setTag("tag");
        this.fixture.addField("a", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        IDefinitionScope definitionScope = VariantDeclarationTest.createDefinitionScope();
        String fieldName = "";
        ByteBuffer allocate = ByteBuffer.allocate(100);
        BitBuffer bb = new BitBuffer(allocate);
        VariantDefinition result = this.fixture.createDefinition(definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testHasField() {
        this.fixture.setTag("");
        String tag = "";
        boolean result = this.fixture.hasField(tag);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testIsTagged() {
        this.fixture.setTag("");
        boolean result = this.fixture.isTagged();
        Assert.assertEquals((Object)true, (Object)result);
    }

    @Test
    public void testIsTagged_null() {
        this.fixture.setTag(null);
        boolean result = this.fixture.isTagged();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testSetTag() {
        this.fixture.setTag("");
        String tag = "";
        this.fixture.setTag(tag);
    }

    @Test
    public void testToString() {
        this.fixture.setTag("");
        String result = this.fixture.toString();
        String left = "[declaration] variant[";
        String right = result.substring(0, left.length());
        Assert.assertEquals((Object)left, (Object)right);
    }

    @Test
    public void hashcodeTest() {
        VariantDeclaration a = new VariantDeclaration();
        Assert.assertEquals((long)this.fixture.hashCode(), (long)a.hashCode());
        VariantDeclaration b = new VariantDeclaration();
        b.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        VariantDeclaration c = new VariantDeclaration();
        c.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        Assert.assertEquals((long)b.hashCode(), (long)c.hashCode());
    }

    @Test
    public void equalsTest() {
        VariantDeclaration a = new VariantDeclaration();
        VariantDeclaration b = new VariantDeclaration();
        b.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        VariantDeclaration c = new VariantDeclaration();
        c.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        VariantDeclaration d = new VariantDeclaration();
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((Object)b, (Object)c);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertEquals((Object)d, (Object)a);
        Assert.assertEquals((Object)c, (Object)b);
        b.setTag("hi");
        Assert.assertNotEquals((Object)b, (Object)c);
        c.setTag("Hello");
        Assert.assertNotEquals((Object)b, (Object)c);
        c.setTag("hi");
        Assert.assertEquals((Object)b, (Object)c);
        b.addField("hello", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        d.addField("hello", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        d.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        d.setTag("hi");
        Assert.assertEquals((Object)b, (Object)d);
        Assert.assertEquals((Object)d, (Object)b);
    }

    @Test
    public void equalsOutOfOrderTest() {
        VariantDeclaration a = new VariantDeclaration();
        VariantDeclaration b = new VariantDeclaration();
        b.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        b.addField("hello", (IDeclaration)new VariantDeclaration());
        a.addField("hello", (IDeclaration)new VariantDeclaration());
        a.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        Assert.assertEquals((Object)b, (Object)a);
    }

    @Test
    public void equalsAddTwiceTest() {
        VariantDeclaration a = new VariantDeclaration();
        VariantDeclaration b = new VariantDeclaration();
        b.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        a.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        Assert.assertEquals((Object)b, (Object)a);
        b.addField("hi", (IDeclaration)new VariantDeclaration());
        Assert.assertNotEquals((Object)b, (Object)a);
    }
}

