/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.parser.tests;

import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.eclipse.tracecompass.ctf.parser.CTFLexer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CtfLexerTest {
    private final List<Token> tokens = new LinkedList<Token>();

    private void tokenize(String content) {
        ANTLRStringStream cs = new ANTLRStringStream(content);
        CTFLexer lexer = new CTFLexer((CharStream)cs);
        this.tokens.clear();
        Token token;
        while ((token = lexer.nextToken()) != Token.EOF_TOKEN) {
            this.tokens.add(token);
        }
        return;
    }

    private void checkToken(int type, String content) {
        Token token = this.tokens.remove(0);
        if (token.getType() != type) {
            Assert.fail((String)("Invalid type [value " + token.getType() + " but expect " + type + "]." + " Fail to tokenize:" + content));
        } else if (token.getText().compareTo(content) != 0) {
            Assert.fail((String)("Invalid content [value " + token.getText() + " but expect " + content + "]."));
        }
    }

    private void checkSingle(int type, String content) {
        this.tokenize(content);
        this.checkToken(type, content);
    }

    @Test
    public void testKeywords() {
        this.checkSingle(4, "align");
        this.checkSingle(19, "const");
        this.checkSingle(10, "char");
        this.checkSingle(24, "double");
        this.checkSingle(26, "enum");
        this.checkSingle(29, "event");
        this.checkSingle(30, "floating_point");
        this.checkSingle(31, "float");
        this.checkSingle(40, "integer");
        this.checkSingle(42, "int");
        this.checkSingle(45, "long");
        this.checkSingle(61, "short");
        this.checkSingle(63, "signed");
        this.checkSingle(65, "stream");
        this.checkSingle(67, "string");
        this.checkSingle(70, "struct");
        this.checkSingle(72, "trace");
        this.checkSingle(73, "typealias");
        this.checkSingle(74, "typedef");
        this.checkSingle(77, "unsigned");
        this.checkSingle(78, "variant");
        this.checkSingle(79, "void");
        this.checkSingle(8, "_Bool");
        this.checkSingle(18, "_Complex");
        this.checkSingle(38, "_Imaginary");
        this.checkSingle(27, "env");
        this.checkSingle(12, "clock");
        this.checkSingle(48, "NaN");
        this.checkSingle(39, "+inf");
        this.checkSingle(49, "-inf");
    }

    @Test
    public void testSymbols() {
        this.tokenize(" , : ... ");
        this.checkToken(80, " ");
        this.checkToken(60, ",");
        this.checkToken(80, " ");
        this.checkToken(14, ":");
        this.checkToken(80, " ");
        this.checkToken(25, "...");
        this.checkToken(80, " ");
        this.tokenize(" = := = ");
        this.checkToken(80, " ");
        this.checkToken(6, "=");
        this.checkToken(80, " ");
        this.checkToken(75, ":=");
        this.checkToken(80, " ");
        this.tokenize(" <<>> ");
        this.checkToken(80, " ");
        this.checkToken(47, "<");
        this.checkToken(47, "<");
        this.checkToken(32, ">");
        this.checkToken(32, ">");
        this.checkToken(80, " ");
        this.tokenize(" ({[]}) ");
        this.checkToken(80, " ");
        this.checkToken(46, "(");
        this.checkToken(43, "{");
        this.checkToken(56, "[");
        this.checkToken(13, "]");
        this.checkToken(58, "}");
        this.checkToken(59, ")");
        this.checkToken(80, " ");
        this.tokenize(";;");
        this.checkToken(71, ";");
        this.checkToken(71, ";");
        this.tokenize(" ++ -- ");
        this.checkToken(80, " ");
        this.checkToken(62, "+");
        this.checkToken(62, "+");
        this.checkToken(80, " ");
        this.checkToken(62, "-");
        this.checkToken(62, "-");
        this.checkToken(80, " ");
        this.tokenize("-> .*.");
        this.checkToken(5, "->");
        this.checkToken(80, " ");
        this.checkToken(22, ".");
        this.checkToken(57, "*");
        this.checkToken(22, ".");
    }

    @Test
    public void testLiterals() {
        this.tokenize("01 02 010");
        this.checkToken(53, "01");
        this.checkToken(80, " ");
        this.checkToken(53, "02");
        this.checkToken(80, " ");
        this.checkToken(53, "010");
        this.tokenize("1 2 10 1024 ");
        this.checkToken(20, "1");
        this.checkToken(80, " ");
        this.checkToken(20, "2");
        this.checkToken(80, " ");
        this.checkToken(20, "10");
        this.checkToken(80, " ");
        this.checkToken(20, "1024");
        this.checkToken(80, " ");
        this.tokenize("0x01 0x02 0x0F0");
        this.checkToken(35, "0x01");
        this.checkToken(80, " ");
        this.checkToken(35, "0x02");
        this.checkToken(80, " ");
        this.checkToken(35, "0x0F0");
    }

    @Test
    public void testLiteralPrefixes() {
        this.checkSingle(35, "0x1");
        this.checkSingle(35, "0X1");
    }

    @Test
    public void testLiteralSuffixes() {
        this.checkSingle(20, "0l");
        this.checkSingle(20, "0L");
        this.checkSingle(20, "0ll");
        this.checkSingle(20, "0LL");
        this.checkSingle(20, "0ul");
        this.checkSingle(20, "0uL");
        this.checkSingle(20, "0ull");
        this.checkSingle(20, "0uLL");
        this.checkSingle(20, "0Ul");
        this.checkSingle(20, "0UL");
        this.checkSingle(20, "0Ull");
        this.checkSingle(20, "0ULL");
    }

    @Test
    public void testLiteralDigits() {
        this.checkSingle(53, "001234567");
        this.checkSingle(20, "123456");
        this.checkSingle(20, "987654");
        this.checkSingle(35, "0x012345");
        this.checkSingle(35, "0x678990");
        this.checkSingle(35, "0xABCDEF");
        this.checkSingle(35, "0xabcdef");
    }

    @Test
    public void testLiteralZero() {
        this.checkSingle(53, "00");
        this.checkSingle(20, "0");
        this.checkSingle(35, "0x0");
    }

    @Test
    public void testCharLiteral() {
        this.checkSingle(9, "'x'");
        this.checkSingle(9, "'\\''");
        this.checkSingle(9, "' '");
        this.checkSingle(9, "L'1'");
    }

    @Test
    public void testEscapeCharLiteral() {
        this.checkSingle(9, "'\\a'");
        this.checkSingle(9, "'\\b'");
        this.checkSingle(9, "'\\f'");
        this.checkSingle(9, "'\\n'");
        this.checkSingle(9, "'\\r'");
        this.checkSingle(9, "'\\t'");
        this.checkSingle(9, "'\\v'");
        this.checkSingle(9, "'\\''");
        this.checkSingle(9, "'\\\"'");
        this.checkSingle(9, "'\\\\'");
        this.checkSingle(9, "'\u0001'");
        this.checkSingle(9, "'\u0001'");
        this.checkSingle(9, "'\u0001'");
        this.checkSingle(9, "'\\x1A'");
        this.checkSingle(9, "'\\x1a'");
        this.checkSingle(9, "'\\xa'");
        this.checkSingle(9, "'\\x0'");
        this.checkSingle(9, "'\uabcd'");
        this.checkSingle(9, "'\u0123'");
        this.checkSingle(9, "'\u012345678'");
        this.checkSingle(9, "'\ufedcBA987'");
    }

    @Test
    public void testStringLiteral() {
        this.checkSingle(69, "\"\"");
        this.checkSingle(69, "\"x\"");
        this.checkSingle(69, "\"\\\"\"");
        this.checkSingle(69, "\" \"");
        this.checkSingle(69, "L\"1\"");
        this.checkSingle(69, "\"This is \\n a multiline\\r\\n\"");
        this.checkSingle(69, "L\"This is \\n a multiline\\r\\n\"");
    }

    @Test
    public void testEscapeStringLiteral() {
        this.checkSingle(69, "\"\\a\"");
        this.checkSingle(69, "\"\\b\"");
        this.checkSingle(69, "\"\\f\"");
        this.checkSingle(69, "\"\\n\"");
        this.checkSingle(69, "\"\\r\"");
        this.checkSingle(69, "\"\\t\"");
        this.checkSingle(69, "\"\\v\"");
        this.checkSingle(69, "\"\\'\"");
        this.checkSingle(69, "\"\\\"\"");
        this.checkSingle(69, "\"\\\\\"");
        this.checkSingle(69, "\"\u0001\"");
        this.checkSingle(69, "\"\u0001\"");
        this.checkSingle(69, "\"\u0001\"");
        this.checkSingle(69, "\"\\x1A\"");
        this.checkSingle(69, "\"\\x1a\"");
        this.checkSingle(69, "\"\\xa\"");
        this.checkSingle(69, "\"\\x0\"");
        this.checkSingle(69, "\"\uabcd\"");
        this.checkSingle(69, "\"\u0123\"");
        this.checkSingle(69, "\"\u012345678\"");
        this.checkSingle(69, "\"\ufedcBA987\"");
    }

    @Test
    public void testWhitespaces() {
        this.tokenize("  \r\t\n\f ");
        this.checkToken(80, " ");
        this.checkToken(80, " ");
        this.checkToken(80, "\r");
        this.checkToken(80, "\t");
        this.checkToken(80, "\n");
        this.checkToken(80, "\f");
        this.checkToken(80, " ");
    }

    @Test
    public void testComment() {
        this.tokenize(" /* test */ ");
        this.checkToken(80, " ");
        this.checkToken(15, "/* test */");
        this.checkToken(80, " ");
    }

    @Test
    public void testNestedComment() {
        this.tokenize(" /* /* */ ");
        this.checkToken(80, " ");
        this.checkToken(15, "/* /* */");
        this.checkToken(80, " ");
        this.tokenize(" /* /* * ** / */ ");
        this.checkToken(80, " ");
        this.checkToken(15, "/* /* * ** / */");
        this.checkToken(80, " ");
    }

    @Test
    public void testMultiLineComment() {
        this.tokenize(" /*\ntest\n*/ ");
        this.checkToken(80, " ");
        this.checkToken(15, "/*\ntest\n*/");
        this.checkToken(80, " ");
    }

    @Test
    public void testLineComment() {
        this.tokenize(" // asdad\r\n ");
        this.checkToken(80, " ");
        this.checkToken(44, "// asdad\r\n");
        this.checkToken(80, " ");
    }

    @Ignore(value="Lexer must be fixed first")
    @Test
    public void testLineCommentWithEOF() {
        this.tokenize("//");
        this.checkToken(44, "//");
    }

    @Test
    public void testMixedComment() {
        this.tokenize(" // /*\n");
        this.checkToken(80, " ");
        this.checkToken(44, "// /*\n");
        this.tokenize(" /*\n//\n*/ ");
        this.checkToken(80, " ");
        this.checkToken(15, "/*\n//\n*/");
        this.checkToken(80, " ");
    }

    @Test
    public void testIdentifier() {
        this.tokenize("_ a a1 B ");
        this.checkToken(37, "_");
        this.checkToken(80, " ");
        this.checkToken(37, "a");
        this.checkToken(80, " ");
        this.checkToken(37, "a1");
        this.checkToken(80, " ");
        this.checkToken(37, "B");
        this.checkToken(80, " ");
    }

    @Test
    public void testIdentifierLetters() {
        this.checkSingle(37, "ABCDEFGHI");
        this.checkSingle(37, "JKLMNOPQR");
        this.checkSingle(37, "STUVWXYZ");
        this.checkSingle(37, "abcdefghi");
        this.checkSingle(37, "jklmnopqr");
        this.checkSingle(37, "stuvwxyz");
        this.checkSingle(37, "_0123456789");
    }
}

