/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlKernelProviderTest {
    private static final String TEST_STREAM = "CreateTreeTest.cfg";
    private static final String SCEN_SCENARIO1_TEST = "Scenario1";
    private TraceControlTestFacility fFacility;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testKernelProviderTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        int i = 0;
        while (i < 20 && node.getTargetNodeState() != TargetNodeState.CONNECTED) {
            ++i;
            this.fFacility.delay(500L);
        }
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        TraceProviderGroup providerGroup = (TraceProviderGroup)groups[0];
        Assert.assertTrue((boolean)providerGroup.hasKernelProvider());
        ITraceControlComponent[] providers = providerGroup.getChildren();
        KernelProviderComponent kernelProvider = (KernelProviderComponent)providers[0];
        ITraceControlComponent[] events = kernelProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)3L, (long)events.length);
        BaseEventComponent baseEventInfo0 = (BaseEventComponent)events[0];
        BaseEventComponent baseEventInfo1 = (BaseEventComponent)events[1];
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)new CreateSessionDialogStub());
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario("SessionHandling");
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120314-132824", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fProxy.setScenario(SCEN_SCENARIO1_TEST);
        ITraceControlComponent[] components = new ITraceControlComponent[]{baseEventInfo0, baseEventInfo1};
        this.fFacility.executeCommand(components, "assign.event");
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"channel0", (Object)channel.getName());
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)262144L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)0L, (long)channel.getSwitchTimer());
        ITraceControlComponent[] channel0Events = channel.getChildren();
        Assert.assertNotNull((Object)channel0Events);
        Assert.assertEquals((long)2L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[1] instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"sched_kthread_stop_ret", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        TraceEventComponent event1 = (TraceEventComponent)channel0Events[1];
        Assert.assertEquals((Object)"sched_kthread_stop", (Object)event1.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event1.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event1.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event1.getState());
        ITraceControlComponent[] selection = new ITraceControlComponent[]{event, event1};
        this.fFacility.executeCommand(selection, "disableEvent");
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event1.getState());
        this.fFacility.executeCommand((ITraceControlComponent)event1, "enableEvent");
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event1.getState());
        this.fProxy.setScenario("SessionHandling");
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

