/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableChannelDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableChannelDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlUstProviderTest {
    private static final String TEST_STREAM = "CreateTreeTest.cfg";
    private static final String SCEN_SCENARIO2_TEST = "Scenario2";
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private TraceControlTestFacility fFacility;
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        this.fProxy = new TestRemoteSystemProxy(this.fHost);
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testUstProviderTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        int i = 0;
        while (i < 10 && node.getTargetNodeState() != TargetNodeState.CONNECTED) {
            ++i;
            this.fFacility.delay(500L);
        }
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        ITraceControlComponent[] providers = groups[0].getChildren();
        KernelProviderComponent kernelProvider = (KernelProviderComponent)providers[0];
        ITraceControlComponent[] events = kernelProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)3L, (long)events.length);
        BaseEventComponent baseEventInfo0 = (BaseEventComponent)events[0];
        BaseEventComponent baseEventInfo1 = (BaseEventComponent)events[1];
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)new CreateSessionDialogStub());
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario("SessionHandlingWithPath");
        CreateSessionDialogStub sessionDialogStub = new CreateSessionDialogStub();
        sessionDialogStub.setSessionPath("/home/user/temp");
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)sessionDialogStub);
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/temp", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fProxy.setScenario(SCEN_SCENARIO2_TEST);
        EnableChannelDialogStub channelDialogStub = new EnableChannelDialogStub();
        channelDialogStub.setDomain(TraceDomainType.UST);
        channelDialogStub.getChannelInfo().setOverwriteMode(false);
        channelDialogStub.getChannelInfo().setSwitchTimer(200L);
        channelDialogStub.getChannelInfo().setReadTimer(100L);
        channelDialogStub.getChannelInfo().setNumberOfSubBuffers(2);
        TraceControlDialogFactory.getInstance().setEnableChannelDialog((IEnableChannelDialog)channelDialogStub);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[0].getName());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        Assert.assertEquals((long)2L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)100L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)16384L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)200L, (long)channel.getSwitchTimer());
        UstProviderComponent ustProvider = (UstProviderComponent)providers[1];
        Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello [PID=9379]", (Object)ustProvider.getName());
        Assert.assertEquals((long)9379L, (long)ustProvider.getPid());
        events = ustProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        baseEventInfo0 = (BaseEventComponent)events[0];
        baseEventInfo1 = (BaseEventComponent)events[1];
        ITraceControlComponent[] ustSelection = new ITraceControlComponent[]{baseEventInfo0, baseEventInfo1};
        this.fFacility.executeCommand(ustSelection, "assign.event");
        domains = session.getChildren();
        channels = domains[0].getChildren();
        ITraceControlComponent[] ustEvents = channels[0].getChildren();
        Assert.assertEquals((long)2L, (long)ustEvents.length);
        TraceEventComponent event = (TraceEventComponent)ustEvents[0];
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        event = (TraceEventComponent)ustEvents[1];
        Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)ustEvents[1].getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        this.fFacility.executeCommand((ITraceControlComponent)event, "disableEvent");
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        this.fFacility.executeCommand((ITraceControlComponent)event, "enableEvent");
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        this.fProxy.setScenario("SessionHandling");
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

