/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableChannelDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableChannelDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlUstSession2Test {
    private static final String TEST_STREAM = "CreateTreeTest2.cfg";
    private static final String SCEN_SCEN_PER_UID_TEST = "ScenPerUidTest";
    private static final String SCEN_SCEN_PER_PID_TEST = "ScenPerPidTest";
    private static final String SCEN_SCEN_BUF_SIZE_TEST = "ScenBufSizeTest";
    private TraceControlTestFacility fFacility;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testTraceSessionTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        int i = 0;
        while (i < 10 && node.getTargetNodeState() != TargetNodeState.CONNECTED) {
            ++i;
            this.fFacility.delay(500L);
        }
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)new CreateSessionDialogStub());
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario(SCEN_SCEN_PER_UID_TEST);
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        EnableChannelDialogStub channelStub = new EnableChannelDialogStub();
        channelStub.setDomain(TraceDomainType.UST);
        ChannelInfo info = (ChannelInfo)channelStub.getChannelInfo();
        info.setName("mychannel");
        info.setOverwriteMode(false);
        info.setSubBufferSize(-1L);
        info.setNumberOfSubBuffers(-1);
        info.setSwitchTimer(-1L);
        info.setReadTimer(-1L);
        info.setMaxNumberTraceFiles(-1);
        info.setMaxSizeTraceFiles(-1L);
        info.setBufferType(BufferType.BUFFER_PER_UID);
        channelStub.setChannelInfo(info);
        TraceControlDialogFactory.getInstance().setEnableChannelDialog((IEnableChannelDialog)channelStub);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[0].getName());
        Assert.assertEquals((String)"Domain buffer Type", (Object)BufferType.BUFFER_PER_UID, (Object)((TraceDomainComponent)domains[0]).getBufferType());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fProxy.setScenario(SCEN_SCEN_PER_PID_TEST);
        session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        info = (ChannelInfo)channelStub.getChannelInfo();
        info.setName("mychannel");
        info.setBufferType(BufferType.BUFFER_PER_PID);
        channelStub.setChannelInfo(info);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[0].getName());
        Assert.assertEquals((String)"Domain buffer Type", (Object)BufferType.BUFFER_PER_PID, (Object)((TraceDomainComponent)domains[0]).getBufferType());
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fProxy.setScenario(SCEN_SCEN_BUF_SIZE_TEST);
        session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        info = (ChannelInfo)channelStub.getChannelInfo();
        info.setName("mychannel");
        info.setMaxNumberTraceFiles(10);
        info.setMaxSizeTraceFiles(1024L);
        info.setBufferType(BufferType.BUFFER_TYPE_UNKNOWN);
        channelStub.setChannelInfo(info);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[0].getName());
        Assert.assertEquals((String)"Domain buffer Type", (Object)BufferType.BUFFER_PER_PID, (Object)((TraceDomainComponent)domains[0]).getBufferType());
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

