/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel;

import java.util.List;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LttngKernelAnalysisTest {
    private LttngKernelTrace fTrace;
    private KernelAnalysisModule fKernelAnalysisModule;

    @Before
    public void setUp() {
        this.fKernelAnalysisModule = new KernelAnalysisModule();
        String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.KERNEL).getPath();
        this.fTrace = new LttngKernelTrace();
        try {
            this.fTrace.initTrace(null, path, CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fKernelAnalysisModule.dispose();
        this.fTrace = null;
        this.fKernelAnalysisModule = null;
    }

    @Test
    public void testAnalysisExecution() {
        this.fKernelAnalysisModule.setId("test");
        LttngKernelTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        try {
            Assert.assertTrue((boolean)this.fKernelAnalysisModule.setTrace((ITmfTrace)trace));
        }
        catch (TmfAnalysisException e) {
            Assert.fail((String)e.getMessage());
        }
        ITmfStateSystem ss = this.fKernelAnalysisModule.getStateSystem();
        Assert.assertNull((Object)ss);
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fKernelAnalysisModule));
        ss = this.fKernelAnalysisModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List quarks = ss.getQuarks(new String[]{"*"});
        Assert.assertFalse((boolean)quarks.isEmpty());
    }

    @Test
    public void testCanExecute() {
        Assert.assertNotNull((Object)this.fTrace);
        Assert.assertTrue((boolean)this.fKernelAnalysisModule.canExecute((ITmfTrace)this.fTrace));
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.CYG_PROFILE);
        Assert.assertTrue((boolean)this.fKernelAnalysisModule.canExecute((ITmfTrace)trace));
        trace.dispose();
    }
}

