/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.execgraph;

import java.io.File;
import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building.LttngKernelExecutionGraph;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class KernelExecutionGraphBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass#Kernel Execution Graph#";
    private static final String TEST_BUILD = "Building Graph (%s)";
    private static final String TEST_MEMORY = "Memory Usage (%s)";
    private static final int LOOP_COUNT = 25;
    private RunMethod cpu = (pm, module) -> {
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        pm.stop();
    };
    private RunMethod memory = (pm, module) -> {
        System.gc();
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        System.gc();
        pm.stop();
    };
    private static final EnumSet<CtfTestTrace> fTraceSet = EnumSet.of(CtfTestTrace.TRACE2, CtfTestTrace.MANY_THREADS, CtfTestTrace.DJANGO_HTTPD);

    @Test
    public void runAllBenchmarks() {
        for (CtfTestTrace trace : fTraceSet) {
            KernelExecutionGraphBenchmark.runOneBenchmark(trace, String.format(TEST_BUILD, trace.toString()), this.cpu, Dimension.CPU_TIME);
            KernelExecutionGraphBenchmark.runOneBenchmark(trace, String.format(TEST_MEMORY, trace.toString()), this.memory, Dimension.USED_JAVA_HEAP);
        }
    }

    private static void runOneBenchmark(@NonNull CtfTestTrace testTrace, String testName, RunMethod method, Dimension dimension) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName);
        perf.tagAsSummary(pm, "Execution graph " + testName, dimension);
        int i = 0;
        while (i < 25) {
            block13: {
                LttngKernelTrace trace = null;
                LttngKernelExecutionGraph module = null;
                String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
                try {
                    try {
                        trace = new LttngKernelTrace();
                        module = new LttngKernelExecutionGraph();
                        module.setId("test");
                        trace.initTrace(null, path, CtfTmfEvent.class);
                        module.setTrace((ITmfTrace)trace);
                        method.execute(pm, (IAnalysisModule)module);
                        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                        File[] fileArray = suppDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        if (trace != null) {
                            trace.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    if (trace != null) {
                        trace.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    private static interface RunMethod {
        public void execute(PerformanceMeter var1, IAnalysisModule var2);
    }
}

