/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.lttng.kernel.core.tests.shared.vm;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.osgi.framework.Bundle;

public enum VmTraces {
    HOST_ONE_QEMUKVM("vm/OneQemuKvm/host.xml"),
    GUEST_ONE_QEMUKVM("vm/OneQemuKvm/guest.xml");

    private static final @NonNull String filePath = "testfiles";
    private final IPath fPath;

    private VmTraces(String path) {
        Path relativePath = new Path(filePath + File.separator + path);
        Activator plugin = Activator.getDefault();
        if (plugin == null) {
            throw new IllegalStateException();
        }
        URL location = FileLocator.find((Bundle)plugin.getBundle(), (IPath)relativePath, null);
        try {
            this.fPath = new Path(FileLocator.toFileURL((URL)location).getPath());
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public @Nullable ITmfTrace getTrace() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IStatus status = trace.validate(null, this.fPath.toOSString());
        if (!status.isOK()) {
            return null;
        }
        try {
            trace.initTrace(null, this.fPath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            return null;
        }
        return trace;
    }

    public boolean exists() {
        return this.fPath.toFile().exists();
    }
}

