/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class KernelTestBase {
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    protected static final String TRACE_PROJECT_NAME = "test";
    protected static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        List openViews = fBot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
            fBot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        }
        KernelTestBase.switchKernelPerspective();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        SWTBotUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    private static void switchKernelPerspective() {
        final Exception[] retE = new Exception[1];
        if (!((Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                try {
                    PlatformUI.getWorkbench().showPerspective(KernelTestBase.KERNEL_PERSPECTIVE_ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    retE[0] = e;
                    return false;
                }
                return true;
            }
        })).booleanValue()) {
            Assert.fail((String)retE[0].getMessage());
        }
    }

    @Before
    public void before() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)LttngTraceGenerator.getPath(), (String)KERNEL_TRACE_TYPE);
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)LttngTraceGenerator.getName());
    }

    @After
    public void after() {
        fBot.closeAllEditors();
    }

    static final class TreeCheckedCounter
    implements Result<Integer> {
        private final SWTBotTree fTreeBot;

        TreeCheckedCounter(SWTBotTree treeBot) {
            this.fTreeBot = treeBot;
        }

        public Integer run() {
            int checked = 0;
            TreeItem[] treeItemArray = ((Tree)this.fTreeBot.widget).getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                checked += this.getChecked(item);
                ++n2;
            }
            return checked;
        }

        private int getChecked(TreeItem item) {
            int total = 0;
            if (item.getChecked()) {
                ++total;
            }
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                total += this.getChecked(child);
                ++n2;
            }
            return total;
        }
    }
}

