/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.swtchart.Chart;

public class ResourcesAndCpuViewTest
extends KernelTestBase {
    private SWTBotView fViewBotRv;
    private SWTBotView fViewBotCpu;

    @Override
    @Before
    public void before() {
        this.fViewBotRv = fBot.viewByPartName("Resources");
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        this.fViewBotCpu = fBot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage");
        this.fViewBotCpu.show();
        this.fViewBotRv.show();
        try {
            SWTBotUtils.openTrace((String)"test", (String)Paths.get(FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL()).toURI()).toString(), (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"bug446190");
        this.fViewBotRv.setFocus();
    }

    @Test
    public void testSignals() {
        Widget widget = this.fViewBotRv.getWidget();
        Assert.assertNotNull((Object)widget);
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        TmfCpuSelectedSignal signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast(signal);
        Assert.assertEquals((String)"Before signal - CPU Usage Title", (Object)"CPU Usage", (Object)this.getTitle());
        Assert.assertEquals((String)"Before signal - Thread Table", (long)12L, (long)this.getTableCount());
        this.fViewBotRv.setFocus();
        signal = new TmfCpuSelectedSignal((Object)widget, 1, activeTrace);
        ResourcesAndCpuViewTest.broadcast(signal);
        Assert.assertEquals((String)"After signal - CPU Usage Title", (Object)"CPU Usage 1", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal - Thread Table", (long)4L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, 3, activeTrace);
        ResourcesAndCpuViewTest.broadcast(signal);
        Assert.assertEquals((String)"After signal 2 - CPU Usage Title", (Object)"CPU Usage 1, 3", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal 2 - Thread Table", (long)8L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast(signal);
        Assert.assertEquals((String)"After signal clear - CPU Usage Title", (Object)"CPU Usage", (Object)this.getTitle());
        Assert.assertEquals((String)"After signal clear - Thread Table", (long)12L, (long)this.getTableCount());
    }

    private static void broadcast(TmfCpuSelectedSignal signal) {
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)signal));
        SWTBotUtils.waitForJobs();
    }

    private String getTitle() {
        this.fViewBotCpu.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)this.fViewBotCpu.bot().widget(matcher);
        return chart.getTitle().getText();
    }

    private int getTableCount() {
        this.fViewBotCpu.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Tree.class);
        SWTBotTree treeBot = new SWTBotTree((Tree)this.fViewBotCpu.bot().widget(matcher));
        int count = 0;
        SWTBotTreeItem[] sWTBotTreeItemArray = treeBot.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem bot = sWTBotTreeItemArray[n2];
            String text = bot.getText();
            if (!text.isEmpty()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

