/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileEndiannessTest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void EndiannessTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.SHORT_LITTLE_ENDIAN;
        Assume.assumeTrue((boolean)trace.exists());
        Path path1 = trace.getPath();
        trace = PcapTestTrace.SHORT_LITTLE_ENDIAN;
        Assume.assumeTrue((boolean)trace.exists());
        Path path2 = PcapTestTrace.SHORT_BIG_ENDIAN.getPath();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            PcapFile littleEndian = new PcapFile(path1);
            try {
                try (PcapFile bigEndian = new PcapFile(path2);){
                    Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)bigEndian.getByteOrder());
                    Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)littleEndian.getByteOrder());
                    while (littleEndian.hasNextPacket() && bigEndian.hasNextPacket()) {
                        Assert.assertEquals((Object)littleEndian.parseNextPacket(), (Object)bigEndian.parseNextPacket());
                    }
                }
                if (littleEndian == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (littleEndian == null) throw throwable;
                littleEndian.close();
                throw throwable;
            }
            littleEndian.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

