/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.tests.backend.StateHistoryBackendTestBase;
import org.junit.After;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HistoryTreeBackendTest
extends StateHistoryBackendTestBase {
    protected static final String SSID = "test";
    protected static final int PROVIDER_VERSION = 0;
    protected static final int MAX_CHILDREN = 2;
    protected static final int BLOCK_SIZE = 4096;
    protected final boolean fReOpen;
    protected Set<File> fHistoryTreeFiles = new HashSet<File>();
    protected Map<IStateHistoryBackend, File> fBackendMap = new HashMap<IStateHistoryBackend, File>();
    protected int fMaxChildren = 2;
    protected int fBlockSize = 4096;

    @Parameterized.Parameters(name="ReOpen={0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(Boolean.FALSE, Boolean.TRUE);
    }

    public HistoryTreeBackendTest(Boolean reOpen) {
        this.fReOpen = reOpen;
    }

    @After
    public void teardown() {
        for (IStateHistoryBackend backend : this.fBackendMap.keySet()) {
            backend.dispose();
        }
        for (File historyTreeFile : this.fHistoryTreeFiles) {
            historyTreeFile.delete();
        }
    }

    @Override
    protected IStateHistoryBackend getBackendForBuilding(long startTime) throws IOException {
        File historyTreeFile = File.createTempFile("HistoryTreeBackendTest", ".ht");
        this.fHistoryTreeFiles.add(historyTreeFile);
        HistoryTreeBackend backend = new HistoryTreeBackend(SSID, historyTreeFile, 0, startTime, this.fBlockSize, this.fMaxChildren);
        this.fBackendMap.put((IStateHistoryBackend)backend, historyTreeFile);
        return backend;
    }

    @Override
    protected IStateHistoryBackend getBackendForQuerying(IStateHistoryBackend backend) throws IOException {
        if (!this.fReOpen) {
            return backend;
        }
        File historyTreeFile = this.fBackendMap.remove(backend);
        backend.dispose();
        HistoryTreeBackend reOpenedBackend = new HistoryTreeBackend(SSID, historyTreeFile, 0);
        this.fBackendMap.put((IStateHistoryBackend)reOpenedBackend, historyTreeFile);
        return reOpenedBackend;
    }
}

