/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend.historytree;

import java.io.File;
import java.io.IOException;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.backend.HistoryTreeBackendStub;
import org.junit.Assert;
import org.junit.Test;

public class HistoryTreeWithBackendTest {
    private static final String SSID = "test";
    private static final int PROVIDER_VERSION = 0;
    private static final int MAX_CHILDREN = 3;
    private static final int BLOCK_SIZE = 4096;

    @Test
    public void testFillNodes() {
        try {
            int nbAttr = 5;
            int depthToRead = 3;
            long startTime = 1L;
            File historyTreeFile = (File)NonNullUtils.checkNotNull((Object)File.createTempFile("HistoryTreeBackendTest", ".ht"));
            HistoryTreeBackendStub backend = new HistoryTreeBackendStub(SSID, historyTreeFile, 0, startTime, 4096, 3);
            int duration = 5;
            int quarkTest = 5;
            long time = startTime + (long)duration;
            HTInterval interval = new HTInterval(startTime, time, quarkTest, TmfStateValue.newValueLong((long)time));
            backend.insertPastState(interval.getStartTime(), interval.getEndTime(), interval.getAttribute(), interval.getStateValue());
            while (backend.getHistoryTree().getDepth() < 3) {
                backend.insertPastState(Math.max(startTime, time - (long)duration), time - 1L, (int)time % 5, (ITmfStateValue)TmfStateValue.newValueLong((long)time));
                ++time;
            }
            HTNode latestLeaf = backend.getHistoryTree().getLatestLeaf();
            while (interval.getSizeOnDisk() <= latestLeaf.getNodeFreeSpace() || latestLeaf.isOnDisk()) {
                backend.insertPastState(Math.max(startTime, time - (long)duration), time - 1L, (int)time % 5, (ITmfStateValue)TmfStateValue.newValueLong((long)time));
                ++time;
            }
            backend.insertPastState(interval.getEndTime() + 1L, time, quarkTest, (ITmfStateValue)TmfStateValue.newValueLong((long)time));
            backend.getHistoryTree().assertIntegrity();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

