/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.statevalue;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.SafeByteBufferFactory;
import org.junit.Assert;
import org.junit.Test;

public class SafeByteBufferWrapperTest {
    private final ByteBuffer fMainBuffer = ByteBuffer.allocate(1024);

    @Test
    public void testReadWriteByte() {
        byte val = 127;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.put(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)val, (long)reader.get());
    }

    @Test
    public void testReadWriteByteArray() {
        byte[] byArray = new byte[4];
        byArray[1] = 2;
        byArray[2] = 1;
        byArray[3] = 3;
        byte[] val = byArray;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.put(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        byte[] ret = new byte[4];
        reader.get(ret);
        Assert.assertArrayEquals((byte[])val, (byte[])ret);
    }

    @Test
    public void testReadWriteChar() {
        char val = '\u0018';
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putChar(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)val, (long)reader.getChar());
    }

    @Test
    public void testReadWriteDouble() {
        double val = Double.MAX_VALUE;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putDouble(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((double)val, (double)reader.getDouble(), (double)10.0);
    }

    @Test
    public void testReadWriteFloat() {
        float val = Float.MIN_VALUE;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putFloat(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((float)val, (float)reader.getFloat(), (float)10.0f);
    }

    @Test
    public void testReadWriteInt() {
        int val = Integer.MAX_VALUE;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putInt(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)val, (long)reader.getInt());
    }

    @Test
    public void testReadWriteLong() {
        long val = Long.MIN_VALUE;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putLong(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)val, (long)reader.getLong());
    }

    @Test
    public void testReadWriteShort() {
        short val = Short.MIN_VALUE;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putShort(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)val, (long)reader.getShort());
    }

    @Test
    public void testReadWriteString() {
        String val = "abcdefg";
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putString(val);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((Object)val, (Object)reader.getString());
    }

    @Test
    public void testMultipleValues() {
        int valInt = 98;
        short valShort = 34;
        String valStr = "myString";
        long valLong = 254238908543254L;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)512);
        buffer.putInt(valInt);
        buffer.putShort(valShort);
        buffer.putString(valStr);
        buffer.putLong(valLong);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)512);
        Assert.assertEquals((long)valInt, (long)reader.getInt());
        Assert.assertEquals((long)valShort, (long)reader.getShort());
        Assert.assertEquals((Object)valStr, (Object)reader.getString());
        Assert.assertEquals((long)valLong, (long)reader.getLong());
    }

    @Test(expected=BufferOverflowException.class)
    public void testLimit() {
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)5);
        buffer.putDouble(Double.MIN_VALUE);
    }

    @Test
    public void testMainBuffer() {
        String valString = "defghi";
        long valLong = 54262542352L;
        int valInt = 2048;
        int bufferSize = 4 + valString.length() + 8;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        buffer.putString(valString);
        buffer.putLong(valLong);
        this.fMainBuffer.putInt(valInt);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        Assert.assertEquals((Object)valString, (Object)reader.getString());
        Assert.assertEquals((long)valLong, (long)reader.getLong());
        Assert.assertEquals((long)valInt, (long)this.fMainBuffer.getInt());
    }

    @Test
    public void testMainBuffer2() {
        String valString = "defghi";
        long valLong = 54262542352L;
        int valInt = 2048;
        int bufferSize = 4 + valString.length() + 8 + 8;
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        buffer.putString(valString);
        buffer.putLong(valLong);
        Assert.assertEquals((long)bufferSize, (long)this.fMainBuffer.position());
        this.fMainBuffer.putInt(valInt);
        buffer.putLong(valLong);
        this.fMainBuffer.flip();
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        Assert.assertEquals((Object)valString, (Object)reader.getString());
        Assert.assertEquals((long)valLong, (long)reader.getLong());
        Assert.assertEquals((long)valLong, (long)reader.getLong());
        Assert.assertEquals((long)valInt, (long)this.fMainBuffer.getInt());
    }

    @Test
    public void testMainBuffer3() {
        String valString = "defghi";
        long valLong = 54262542352L;
        int valInt = 2048;
        int bufferSize = 4 + valString.length() + 8;
        this.fMainBuffer.putLong(valLong);
        this.fMainBuffer.putInt(valInt);
        ISafeByteBufferWriter buffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        buffer.putString(valString);
        buffer.putLong(valLong);
        this.fMainBuffer.flip();
        Assert.assertEquals((long)valLong, (long)this.fMainBuffer.getLong());
        Assert.assertEquals((long)valInt, (long)this.fMainBuffer.getInt());
        ISafeByteBufferReader reader = SafeByteBufferFactory.wrapReader((ByteBuffer)this.fMainBuffer, (int)bufferSize);
        Assert.assertEquals((Object)valString, (Object)reader.getString());
        Assert.assertEquals((long)valLong, (long)reader.getLong());
    }
}

