/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.stubs.backend;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTree;
import org.junit.Assert;

public class HistoryTreeStub
extends HistoryTree {
    public HistoryTreeStub(HTConfig conf) throws IOException {
        super(conf);
    }

    public HistoryTreeStub(File existingStateFile, int expProviderVersion) throws IOException {
        super(existingStateFile, expProviderVersion);
    }

    public List<HTNode> getLatestBranch() {
        return (List)NonNullUtils.checkNotNull((Object)super.getLatestBranch());
    }

    public HTNode getLatestLeaf() {
        List<HTNode> latest = this.getLatestBranch();
        return (HTNode)Iterables.getLast(latest);
    }

    public HTNode getNodeAt(int pos) {
        List<HTNode> latest = this.getLatestBranch();
        return latest.get(pos);
    }

    public int getDepth() {
        return this.getLatestBranch().size();
    }

    private void assertChildrenIntegrity(CoreNode node) {
        try {
            if (node.getNbChildren() > 0) {
                HTNode childNode = this.getNode(node.getChild(0));
                Assert.assertEquals((String)("Equals start time of parent " + node.getSequenceNumber() + " and first child " + childNode.getSequenceNumber()), (long)node.getNodeStart(), (long)childNode.getNodeStart());
                if (node.isOnDisk()) {
                    childNode = this.getNode(node.getLatestChild());
                    Assert.assertEquals((String)("Equals end time of parent " + node.getSequenceNumber() + " and last child " + childNode.getSequenceNumber()), (long)node.getNodeEnd(), (long)childNode.getNodeEnd());
                }
            }
            int i = 0;
            while (i < node.getNbChildren()) {
                HTNode childNode = this.getNode(node.getChild(i));
                Assert.assertEquals((String)("Start time in parent " + node.getSequenceNumber() + " of child at index " + i), (long)childNode.getNodeStart(), (long)node.getChildStart(i));
                Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has correct start time"), (node.getNodeStart() <= childNode.getNodeStart() ? 1 : 0) != 0);
                if (node.isOnDisk() && childNode.isOnDisk()) {
                    Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has correct start time"), (childNode.getNodeEnd() <= childNode.getNodeEnd() ? 1 : 0) != 0);
                }
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void assertNodeIntegrity(HTNode node) {
        if (node instanceof CoreNode) {
            this.assertChildrenIntegrity((CoreNode)node);
        }
    }

    public void assertIntegrity() {
        try {
            int i = 0;
            while (i < this.getNodeCount()) {
                this.assertNodeIntegrity(this.getNode(i));
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

