/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class StateProviderModelTest {
    private static final @NonNull String testTrace1 = "test_traces/testTrace1.xml";

    @Test
    public void testEventName() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(testTrace1);
        XmlStateSystemModule module = XmlUtilsTest.initializeModule(TmfXmlTestFiles.ATTRIBUTE_FILE);
        try {
            try {
                module.setTrace(trace);
                module.schedule();
                module.waitForCompletion();
                ITmfStateSystem ss = module.getStateSystem();
                Assert.assertNotNull((Object)ss);
                List quarks = ss.getQuarks(new String[]{"*"});
                Assert.assertEquals((long)2L, (long)quarks.size());
                for (Integer quark : quarks) {
                    String name;
                    switch (name = ss.getAttributeName(quark.intValue())) {
                        case "test": {
                            int[] expectedStarts = new int[]{1, 5, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2)};
                            XmlUtilsTest.verifyStateIntervals("test", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "test1": {
                            int[] expectedStarts = new int[]{1, 3, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2)};
                            XmlUtilsTest.verifyStateIntervals("test1", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        default: {
                            Assert.fail((String)("Wrong attribute name " + name));
                        }
                    }
                }
            }
            catch (AttributeNotFoundException | StateSystemDisposedException | TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                module.dispose();
                trace.dispose();
            }
        }
        finally {
            module.dispose();
            trace.dispose();
        }
    }
}

