/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternSegmentBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stubs.PatternSegmentFactoryStub;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stubs.StateSystemContainerStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TmfXmlPatternSegmentBuilderTest {
    private static final @NonNull String ANALYSIS_ID = "xml test pattern segment";
    private final @NonNull StateSystemContainerStub fContainer = new StateSystemContainerStub();
    private final @NonNull ITmfXmlModelFactory fModelFactory = TmfXmlReadWriteModelFactory.getInstance();
    private File fTestXmlFile;

    @Before
    public void testXmlValidate() {
        IStatus status;
        this.fTestXmlFile = TmfXmlTestFiles.VALID_PATTERN_SEGMENT.getFile();
        if (this.fTestXmlFile == null || !this.fTestXmlFile.exists()) {
            Assert.fail((String)"XML pattern test file does not exist");
        }
        if (!(status = XmlUtils.xmlValidate((File)this.fTestXmlFile)).isOK()) {
            Assert.fail((String)status.getMessage());
        }
    }

    @Test
    public void testBuilder() {
        Element doc = XmlUtils.getElementInFile((String)this.fTestXmlFile.getPath(), (String)"pattern", (String)ANALYSIS_ID);
        NodeList patternSegments = doc.getElementsByTagName("segment");
        Assert.assertEquals((String)"Number of pattern segments", (long)2L, (long)patternSegments.getLength());
        Node item2 = patternSegments.item(1);
        Assert.assertNotNull((String)"pattern segment 2", (Object)item2);
        TmfXmlPatternSegmentBuilder builder = new TmfXmlPatternSegmentBuilder(this.fModelFactory, (Element)item2, (IXmlStateSystemContainer)this.fContainer);
        Assert.assertNotNull((String)"builder", (Object)builder);
        TmfXmlPatternSegment segment = builder.generatePatternSegment(PatternSegmentFactoryStub.TEST_2_END_EVENT, PatternSegmentFactoryStub.TEST_2_START_EVENT.getTimestamp(), PatternSegmentFactoryStub.TEST_2_END_EVENT.getTimestamp(), null);
        XmlUtilsTest.testPatternSegmentData(PatternSegmentFactoryStub.TEST_2, segment);
    }
}

