/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.format;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRange;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class ChartTimeStampFormat
extends Format {
    private static final long serialVersionUID = 8102026791684954897L;
    private final TmfTimestampFormat fFormat;
    private @Nullable ChartRangeMap fRangeMap;

    public ChartTimeStampFormat(@Nullable ChartRangeMap map) {
        this.fFormat = (TmfTimestampFormat)NonNullUtils.checkNotNull((Object)TmfTimestampFormat.getDefaulTimeFormat());
        this.fRangeMap = map;
    }

    public ChartTimeStampFormat(String pattern, @Nullable ChartRangeMap map) {
        this.fFormat = new TmfTimestampFormat(pattern);
        this.fRangeMap = map;
    }

    public void setRangeMap(ChartRangeMap map) {
        this.fRangeMap = map;
    }

    @Override
    public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        if (!(obj instanceof Number) || toAppendTo == null) {
            throw new IllegalArgumentException("Cannot format given Object as a Number: " + obj);
        }
        Number number = (Number)obj;
        ChartRangeMap rangeMap = this.fRangeMap;
        if (rangeMap == null) {
            long time = ((Number)obj).longValue();
            return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format(time)));
        }
        ChartRange internalRange = rangeMap.getPlottedRange();
        ChartRange externalRange = rangeMap.getInputDataRange();
        if (internalRange.isDeltaNull() || externalRange.isDeltaNull()) {
            return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format((Object)externalRange.getMinimum().doubleValue())));
        }
        BigDecimal externalValue = ((ChartRangeMap)NonNullUtils.checkNotNull((Object)this.fRangeMap)).getExternalValue(number);
        return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format(externalValue.longValue())));
    }

    @Override
    public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
        return null;
    }
}

