/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis.requirements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfCompositeAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeRequirementTest {
    private static final @NonNull TmfAbstractAnalysisRequirement FALSE_REQ1 = new TmfAbstractAnalysisRequirement(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY){

        public boolean test(ITmfTrace trace) {
            return false;
        }
    };
    private static final @NonNull TmfAbstractAnalysisRequirement FALSE_REQ2 = new TmfAbstractAnalysisRequirement(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY){

        public boolean test(ITmfTrace trace) {
            return false;
        }
    };
    private static final @NonNull TmfAbstractAnalysisRequirement TRUE_REQ1 = new TmfAbstractAnalysisRequirement(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY){

        public boolean test(ITmfTrace trace) {
            return true;
        }
    };
    private static final @NonNull TmfAbstractAnalysisRequirement TRUE_REQ2 = new TmfAbstractAnalysisRequirement(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY){

        public boolean test(ITmfTrace trace) {
            return true;
        }
    };
    private ITmfTrace fTrace;

    @Before
    public void setupTrace() {
        this.fTrace = new TmfTraceStub();
    }

    @Test
    public void testMandatory() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TmfCompositeAnalysisRequirement req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1, (Object)TRUE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)FALSE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)trace));
    }

    @Test
    public void testAtLeastOne() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TmfCompositeAnalysisRequirement req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1, (Object)TRUE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertFalse((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)FALSE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertFalse((boolean)req.test((Object)trace));
    }

    @Test
    public void testAllOrNothing() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TmfCompositeAnalysisRequirement req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1, (Object)TRUE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertFalse((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)FALSE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)trace));
    }

    @Test
    public void testOptional() {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TmfCompositeAnalysisRequirement req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)TRUE_REQ1, (Object)TRUE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)TRUE_REQ1), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)trace));
        req = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)FALSE_REQ1, (Object)FALSE_REQ2), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)trace));
    }
}

