/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.parsers.custom.AbstractCustomTraceDataTest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomXmlTraceDataTest
extends AbstractCustomTraceDataTest {
    private static final String TRACE_PATH = String.valueOf(TRACE_DIRECTORY) + File.separator + "test.xml";
    private static final String DEFINITION_PATH = "testfiles" + File.separator + "xml" + File.separator + "testDefinition.xml";
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_XML = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private CustomXmlTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomXmlTraceDataTest.getDefinition(0);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write("<trace>");
                int i = 0;
                while (i < 10) {
                    SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
                    String eventStr = "<element time=\"" + f.format(new Date(i)) + "\">message</element>\n";
                    writer.write(eventStr);
                    ++i;
                }
                writer.write("</trace>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomXmlTrace trace = new CustomXmlTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomXmlEvent));
            String name = this.fDefinition.definitionName;
            Assert.assertEquals((String)"Event name", (Object)name, (Object)event.getName());
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)Long.toString(event.getTimestamp().toNanos()), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_XML_EVENT_NAME = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private static final String DEFAULT_EVENT = "DefaultName";
        private static final String ATTRIBUTE_EVENT = "AttributeName";
        private static final String ELEMENT_EVENT = "ElementName";
        private CustomXmlTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomXmlTraceDataTest.getDefinition(1);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write("<trace>");
                int i = 0;
                while (i < 10) {
                    String attribute = i % 5 != 0 ? String.format(" type=\"%s\"", ATTRIBUTE_EVENT) : "";
                    String element = i % 5 != 0 && i % 2 != 0 ? String.format("<type>%s</type>", ELEMENT_EVENT) : "";
                    String eventStr = String.format("<element time=\"" + i + "\"%s>%s</element>\n", attribute, element);
                    writer.write(eventStr);
                    ++i;
                }
                writer.write("</trace>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomXmlTrace trace = new CustomXmlTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomXmlEvent));
            long ts = event.getTimestamp().getValue();
            if (ts % 5L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)DEFAULT_EVENT, (Object)event.getName());
            } else if (ts % 2L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)ATTRIBUTE_EVENT, (Object)event.getName());
            } else {
                Assert.assertEquals((String)"Event name", (Object)ELEMENT_EVENT, (Object)event.getName());
            }
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)TmfBaseAspects.getTimestampAspect().resolve(event), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };

    public CustomXmlTraceDataTest(String name, @NonNull AbstractCustomTraceDataTest.ICustomTestData data) {
        super(data);
    }

    private static CustomXmlTraceDefinition getDefinition(int index) {
        CustomXmlTraceDefinition[] definitions = CustomXmlTraceDefinition.loadAll((String)new File(DEFINITION_PATH).toString());
        return definitions[index];
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Base parser", CUSTOM_XML}, {"Parse with event name", CUSTOM_XML_EVENT_NAME});
    }
}

