/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.request;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.IllformedLocaleException;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.tests.stubs.request.TmfEventRequestStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TmfCoalescedEventRequestTest {
    private final TmfTimeRange range1 = TmfTimeRange.ETERNITY;
    private final TmfTimeRange range2 = new TmfTimeRange(TmfTimestamp.create((long)0L, (int)0), TmfTimestamp.BIG_CRUNCH);
    private TmfCoalescedEventRequest fRequest1;
    private TmfCoalescedEventRequest fRequest2;
    private TmfCoalescedEventRequest fRequest3;
    private TmfCoalescedEventRequest fRequest4;
    private TmfCoalescedEventRequest fRequest1c;
    private int fRequestCount;
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static final int NB_EVENTS = 5000;
    private TmfTraceStub fTrace = null;
    Vector<ITmfEvent> requestedEvents1;
    Vector<ITmfEvent> requestedEvents2;
    Vector<ITmfEvent> requestedEvents3;
    TmfEventRequest request1;
    TmfEventRequest request2;
    TmfEventRequest request3;
    ITmfEventProvider[] providers;

    @Before
    public void setUp() {
        this.fRequest1 = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        this.fRequest2 = new TmfCoalescedEventRequest(ITmfEvent.class, this.range2, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        this.fRequest3 = new TmfCoalescedEventRequest(ITmfEvent.class, this.range2, 0L, 200, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        this.fRequest4 = new TmfCoalescedEventRequest(ITmfEvent.class, this.range2, 0L, 200, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        this.fRequest1c = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        this.fRequestCount = this.fRequest1c.getRequestId() + 1;
    }

    private TmfCoalescedEventRequest setupTestRequest(final boolean[] flags) {
        TmfCoalescedEventRequest request = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0){

            public void handleCompleted() {
                super.handleCompleted();
                flags[0] = true;
            }

            public void handleSuccess() {
                super.handleSuccess();
                flags[1] = true;
            }

            public void handleFailure() {
                super.handleFailure();
                flags[2] = true;
            }

            public void handleCancel() {
                super.handleCancel();
                flags[3] = true;
            }
        };
        return request;
    }

    @Test
    public void testTmfCoalescedEventRequestIndexNbEventsBlocksize() {
        TmfCoalescedEventRequest request = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        Assert.assertEquals((String)"getRequestId", (long)this.fRequestCount++, (long)request.getRequestId());
        Assert.assertEquals((String)"getDataType", ITmfEvent.class, (Object)request.getDataType());
        Assert.assertEquals((String)"getRange", (Object)this.range1, (Object)request.getRange());
        Assert.assertEquals((String)"getNbRequestedEvents", (long)100L, (long)request.getNbRequested());
        Assert.assertFalse((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertEquals((String)"getNbRead", (long)0L, (long)request.getNbRead());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.fRequest1.equals(this.fRequest1));
        Assert.assertFalse((boolean)this.fRequest1.equals(this.fRequest2));
        Assert.assertFalse((boolean)this.fRequest1.equals(this.fRequest3));
        Assert.assertFalse((boolean)this.fRequest1.equals(this.fRequest4));
    }

    @Test
    public void testToString() {
        String expected1 = "[TmfCoalescedEventRequest(" + this.fRequest1.getRequestId() + ",ITmfEvent,FOREGROUND," + this.range1 + ",0,100, [])]";
        String expected2 = "[TmfCoalescedEventRequest(" + this.fRequest2.getRequestId() + ",ITmfEvent,FOREGROUND," + this.range2 + ",0,100, [])]";
        String expected3 = "[TmfCoalescedEventRequest(" + this.fRequest3.getRequestId() + ",ITmfEvent,FOREGROUND," + this.range2 + ",0,200, [])]";
        String expected4 = "[TmfCoalescedEventRequest(" + this.fRequest4.getRequestId() + ",ITmfEvent,FOREGROUND," + this.range2 + ",0,200, [])]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)this.fRequest1.toString());
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)this.fRequest2.toString());
        Assert.assertEquals((String)"toString", (Object)expected3, (Object)this.fRequest3.toString());
        Assert.assertEquals((String)"toString", (Object)expected4, (Object)this.fRequest4.toString());
    }

    @Test
    public void testIsCompatible() {
        TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        TmfEventRequestStub req1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        TmfEventRequestStub req2 = new TmfEventRequestStub(ITmfEvent.class, this.range2, 100, 200);
        TmfEventRequestStub req3 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 101, 200);
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req1));
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req2));
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req3));
    }

    @Test
    public void testIsCompatibleDependency() {
        TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
        TmfEventRequestStub req1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        TmfEventRequestStub req2 = new TmfEventRequestStub(ITmfEvent.class, this.range2, 100, 2000, ITmfEventRequest.ExecutionType.FOREGROUND, 1);
        TmfEventRequestStub req3 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 101, 200, ITmfEventRequest.ExecutionType.FOREGROUND, 2);
        Assert.assertFalse((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req1));
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req2));
        Assert.assertFalse((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req3));
        coalescedRequest = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, 100, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req1));
        Assert.assertFalse((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req2));
        Assert.assertFalse((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req3));
    }

    @Test
    public void testAddEvent1() {
        TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        TmfEventRequestStub req1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 0L, Integer.MAX_VALUE, 200);
        TmfEventRequestStub req2 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 1L, Integer.MAX_VALUE, 200);
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req1));
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req2));
        coalescedRequest.addRequest((ITmfEventRequest)req1);
        coalescedRequest.addRequest((ITmfEventRequest)req2);
        Assert.assertEquals((String)"addRequest", (long)0L, (long)coalescedRequest.getIndex());
        Assert.assertEquals((String)"addRequest", (long)Integer.MAX_VALUE, (long)coalescedRequest.getNbRequested());
    }

    @Test
    public void testAddEvent2() {
        TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(ITmfEvent.class, this.range1, 1L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, 0);
        TmfEventRequestStub req1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 1L, Integer.MAX_VALUE, 200);
        TmfEventRequestStub req2 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 0L, Integer.MAX_VALUE, 200);
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req1));
        Assert.assertTrue((String)"isCompatible", (boolean)coalescedRequest.isCompatible((ITmfEventRequest)req2));
        coalescedRequest.addRequest((ITmfEventRequest)req1);
        coalescedRequest.addRequest((ITmfEventRequest)req2);
        Assert.assertEquals((String)"addRequest", (long)0L, (long)coalescedRequest.getIndex());
        Assert.assertEquals((String)"addRequest", (long)Integer.MAX_VALUE, (long)coalescedRequest.getNbRequested());
    }

    @Test
    public void testDone() {
        boolean[] crFlags = new boolean[4];
        TmfCoalescedEventRequest request = this.setupTestRequest(crFlags);
        TmfEventRequestStub subRequest1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        TmfEventRequestStub subRequest2 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        request.addRequest((ITmfEventRequest)subRequest1);
        request.addRequest((ITmfEventRequest)subRequest2);
        request.done();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)crFlags[0]);
        Assert.assertTrue((String)"handleSuccess", (boolean)crFlags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)crFlags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)crFlags[3]);
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest1.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)subRequest1.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)subRequest1.isCancelled());
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest2.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)subRequest2.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)subRequest2.isCancelled());
    }

    @Test
    public void testFail() {
        boolean[] crFlags = new boolean[4];
        TmfCoalescedEventRequest request = this.setupTestRequest(crFlags);
        TmfEventRequestStub subRequest1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        TmfEventRequestStub subRequest2 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        request.addRequest((ITmfEventRequest)subRequest1);
        request.addRequest((ITmfEventRequest)subRequest2);
        request.fail((Exception)new IllformedLocaleException("Hi"));
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertTrue((String)"isFailed", (boolean)request.isFailed());
        Throwable failCause = request.getFailureCause();
        Assert.assertNotNull((String)"Cause of failure", (Object)failCause);
        Assert.assertEquals((String)"Cause of failure message", (Object)"Hi", (Object)failCause.getMessage());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)crFlags[0]);
        Assert.assertFalse((String)"handleSuccess", (boolean)crFlags[1]);
        Assert.assertTrue((String)"handleFailure", (boolean)crFlags[2]);
        Assert.assertFalse((String)"handleCancel", (boolean)crFlags[3]);
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest1.isCompleted());
        Assert.assertTrue((String)"isFailed", (boolean)subRequest1.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)subRequest1.isCancelled());
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest2.isCompleted());
        Assert.assertTrue((String)"isFailed", (boolean)subRequest2.isFailed());
        Assert.assertFalse((String)"isCancelled", (boolean)subRequest2.isCancelled());
    }

    @Test
    public void testCancel() {
        boolean[] crFlags = new boolean[4];
        TmfCoalescedEventRequest request = this.setupTestRequest(crFlags);
        TmfEventRequestStub subRequest1 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        TmfEventRequestStub subRequest2 = new TmfEventRequestStub(ITmfEvent.class, this.range1, 100, 200);
        request.addRequest((ITmfEventRequest)subRequest1);
        request.addRequest((ITmfEventRequest)subRequest2);
        request.cancel();
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)request.isFailed());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
        Assert.assertTrue((String)"handleCompleted", (boolean)crFlags[0]);
        Assert.assertFalse((String)"handleSuccess", (boolean)crFlags[1]);
        Assert.assertFalse((String)"handleFailure", (boolean)crFlags[2]);
        Assert.assertTrue((String)"handleCancel", (boolean)crFlags[3]);
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest1.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)subRequest1.isFailed());
        Assert.assertTrue((String)"isCancelled", (boolean)subRequest1.isCancelled());
        Assert.assertTrue((String)"isCompleted", (boolean)subRequest2.isCompleted());
        Assert.assertFalse((String)"isFailed", (boolean)subRequest2.isFailed());
        Assert.assertTrue((String)"isCancelled", (boolean)subRequest2.isCancelled());
    }

    private synchronized TmfTraceStub setupTrace(String path) {
        if (this.fTrace == null) {
            try {
                URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
                File test = new File(FileLocator.toFileURL((URL)location).toURI());
                this.fTrace = new TmfTraceStub(test.getPath(), 500, false, null);
            }
            catch (TmfTraceException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.fTrace;
    }

    @TmfSignalHandler
    public void trigger(final TmfTestTriggerSignal signal) {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        long REQUEST_OFFSET = 1000L;
        this.requestedEvents1 = new Vector();
        this.request1 = new TmfEventRequest(ITmfEvent.class, range, signal.fIndex, 5000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (!this.isCompleted()) {
                    TmfCoalescedEventRequestTest.this.requestedEvents1.add(event);
                    if (signal.forceCancel) {
                        this.cancel();
                    }
                }
            }
        };
        this.requestedEvents2 = new Vector();
        this.request2 = new TmfEventRequest(ITmfEvent.class, range, signal.fIndex + 1000L, 5000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (!this.isCompleted()) {
                    TmfCoalescedEventRequestTest.this.requestedEvents2.add(event);
                }
            }
        };
        this.requestedEvents3 = new Vector();
        this.request3 = new TmfEventRequest(ITmfEvent.class, range, signal.fIndex + 2000L, 5000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (!this.isCompleted()) {
                    TmfCoalescedEventRequestTest.this.requestedEvents3.add(event);
                }
            }
        };
        this.providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        this.providers[0].sendRequest((ITmfEventRequest)this.request1);
        this.providers[0].sendRequest((ITmfEventRequest)this.request2);
        this.providers[0].sendRequest((ITmfEventRequest)this.request3);
    }

    @TmfSignalHandler
    public void trigger(TmfTestTriggerSignal2 signal) {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.create((long)100L, (int)-3), TmfTimestamp.BIG_CRUNCH);
        this.requestedEvents1 = new Vector();
        this.request1 = new TmfEventRequest(ITmfEvent.class, range, 0L, 1, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (!this.isCompleted()) {
                    TmfCoalescedEventRequestTest.this.requestedEvents1.add(event);
                }
            }
        };
        this.providers = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        this.providers[0].sendRequest((ITmfEventRequest)this.request1);
    }

    public void runCoalescedRequest(long startIndex) throws InterruptedException {
        this.fTrace = this.setupTrace(TEST_TRACE.getFullPath());
        TmfSignalManager.register((Object)this);
        TmfTestTriggerSignal signal = new TmfTestTriggerSignal(this, startIndex, false);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        this.request1.waitForCompletion();
        this.request2.waitForCompletion();
        this.request3.waitForCompletion();
        try {
            Assert.assertEquals((String)"Request1: nbEvents", (long)5000L, (long)this.requestedEvents1.size());
            Assert.assertTrue((String)"Request1: isCompleted", (boolean)this.request1.isCompleted());
            Assert.assertFalse((String)"Request1: isCancelled", (boolean)this.request1.isCancelled());
            Assert.assertEquals((String)"Request2: nbEvents", (long)5000L, (long)this.requestedEvents2.size());
            Assert.assertTrue((String)"Request2: isCompleted", (boolean)this.request2.isCompleted());
            Assert.assertFalse((String)"Request2: isCancelled", (boolean)this.request2.isCancelled());
            Assert.assertEquals((String)"Request3: nbEvents", (long)5000L, (long)this.requestedEvents3.size());
            Assert.assertTrue((String)"Request3: isCompleted", (boolean)this.request3.isCompleted());
            Assert.assertFalse((String)"Request3: isCancelled", (boolean)this.request3.isCancelled());
            int i = 0;
            while (i < 5000) {
                Assert.assertEquals((String)"Distinct events", (long)((long)(i + 1) + this.request1.getIndex()), (long)this.requestedEvents1.get(i).getTimestamp().getValue());
                Assert.assertEquals((String)"Distinct events", (long)((long)(i + 1) + this.request2.getIndex()), (long)this.requestedEvents2.get(i).getTimestamp().getValue());
                Assert.assertEquals((String)"Distinct events", (long)((long)(i + 1) + this.request3.getIndex()), (long)this.requestedEvents3.get(i).getTimestamp().getValue());
                ++i;
            }
        }
        finally {
            TmfSignalManager.deregister((Object)this);
            this.fTrace.dispose();
            this.fTrace = null;
        }
    }

    @Test
    public void testCoalescedRequest() throws InterruptedException {
        this.runCoalescedRequest(0L);
        this.runCoalescedRequest(1L);
        this.runCoalescedRequest(5L);
    }

    @Test
    public void testCancelCoalescedRequest() throws InterruptedException {
        this.fTrace = this.setupTrace(TEST_TRACE.getFullPath());
        TmfSignalManager.register((Object)this);
        TmfTestTriggerSignal signal = new TmfTestTriggerSignal(this, 0L, true);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        this.request1.waitForCompletion();
        this.request2.waitForCompletion();
        this.request3.waitForCompletion();
        Assert.assertTrue((String)"Request1: isCompleted", (boolean)this.request1.isCompleted());
        Assert.assertTrue((String)"Request1: isCancelled", (boolean)this.request1.isCancelled());
        Assert.assertEquals((String)"Request2: nbEvents", (long)5000L, (long)this.requestedEvents2.size());
        Assert.assertTrue((String)"Request2: isCompleted", (boolean)this.request2.isCompleted());
        Assert.assertFalse((String)"Request2: isCancelled", (boolean)this.request2.isCancelled());
        Assert.assertEquals((String)"Request3: nbEvents", (long)5000L, (long)this.requestedEvents3.size());
        Assert.assertTrue((String)"Request3: isCompleted", (boolean)this.request3.isCompleted());
        Assert.assertFalse((String)"Request3: isCancelled", (boolean)this.request3.isCancelled());
        int i = 0;
        while (i < 5000) {
            Assert.assertEquals((String)"Distinct events", (long)((long)(i + 1) + this.request2.getIndex()), (long)this.requestedEvents2.get(i).getTimestamp().getValue());
            Assert.assertEquals((String)"Distinct events", (long)((long)(i + 1) + this.request3.getIndex()), (long)this.requestedEvents3.get(i).getTimestamp().getValue());
            ++i;
        }
        TmfSignalManager.deregister((Object)this);
        this.fTrace.dispose();
        this.fTrace = null;
    }

    @Test
    public void testSingleTimeRequest() throws InterruptedException {
        this.fTrace = this.setupTrace(TEST_TRACE.getFullPath());
        TmfSignalManager.register((Object)this);
        TmfTestTriggerSignal2 signal = new TmfTestTriggerSignal2(this);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        this.request1.waitForCompletion();
        Assert.assertTrue((String)"Request1: isCompleted", (boolean)this.request1.isCompleted());
        Assert.assertEquals((String)"Request1: nbEvents", (long)1L, (long)this.requestedEvents1.size());
        TmfSignalManager.deregister((Object)this);
        this.fTrace.dispose();
        this.fTrace = null;
    }

    private static class TmfTestTriggerSignal
    extends TmfSignal {
        public final boolean forceCancel;
        public final long fIndex;

        public TmfTestTriggerSignal(Object source, long index, boolean cancel) {
            super(source);
            this.forceCancel = cancel;
            this.fIndex = index;
        }
    }

    private static class TmfTestTriggerSignal2
    extends TmfSignal {
        public TmfTestTriggerSignal2(Object source) {
            super(source);
        }
    }
}

