/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.shared;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub2;
import org.osgi.framework.Bundle;

public enum TmfTestTrace {
    A_TEST_10K("A-Test-10K"),
    A_TEST_10K2("A-Test-10K-2"),
    E_TEST_10K("E-Test-10K"),
    O_TEST_10K("O-Test-10K"),
    R_TEST_10K("R-Test-10K");

    private final @NonNull String fPath;
    private final String fDirectory = "../../tmf/org.eclipse.tracecompass.tmf.core.tests/testfiles";
    private ITmfTrace fTrace = null;

    private TmfTestTrace(String file) {
        this.fPath = file;
    }

    public @NonNull String getPath() {
        return this.fPath;
    }

    public String getFullPath() {
        return "../../tmf/org.eclipse.tracecompass.tmf.core.tests/testfiles" + File.separator + this.fPath;
    }

    public @NonNull ITmfTrace getTrace() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
        }
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path("../../tmf/org.eclipse.tracecompass.tmf.core.tests/testfiles" + File.separator + this.fPath), null);
        try {
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            TmfTraceStub trace = new TmfTraceStub(test.toURI().getPath(), 1000, false, null);
            this.fTrace = trace;
            return trace;
        }
        catch (IOException | URISyntaxException | TmfTraceException e) {
            throw new IllegalStateException(e);
        }
    }

    public ITmfTrace getTraceAsStub2() {
        TmfTraceStub2 trace = null;
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path("../../tmf/org.eclipse.tracecompass.tmf.core.tests/testfiles" + File.separator + this.fPath), null);
        try {
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            trace = new TmfTraceStub2(test.toURI().getPath(), 1000, false, null);
            TmfSignalManager.deregister((Object)((Object)trace));
        }
        catch (IOException | URISyntaxException | TmfTraceException e) {
            throw new IllegalStateException(e);
        }
        return trace;
    }

    public void dispose() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
            this.fTrace = null;
        }
    }
}

