/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem;

import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.Messages;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemModule;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemProvider;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class StateSystemAnalysisModuleTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    public static final String MODULE_SS = "org.eclipse.linuxtools.tmf.core.tests.analysis.sstest";
    private static final String XML_TRACE = "testfiles/stub_xml_traces/valid/analysis_dependency.xml";
    private TestStateSystemModule fModule;
    private ITmfTrace fTrace;
    private static final String CRUCIAL_EVENT = "crucialEvent";
    private static final String CRUCIAL_FIELD = "crucialInfo";

    @Before
    public void setupTraces() {
        TmfXmlTraceStub trace = TmfXmlTraceStub.setupTrace(TmfCoreTestPlugin.getAbsoluteFilePath(XML_TRACE));
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fTrace = trace;
        this.fModule = (TestStateSystemModule)trace.getAnalysisModule(MODULE_SS);
    }

    @After
    public void cleanupTraces() {
        this.fTrace.dispose();
    }

    @Test
    public void testSsModule() {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNull((Object)ss);
        this.fModule.schedule();
        if (this.fModule.waitForCompletion()) {
            ss = this.fModule.getStateSystem();
            Assert.assertNotNull((Object)ss);
        } else {
            Assert.fail((String)"Module did not complete properly");
        }
    }

    @Test
    public void testInitialization() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        this.fModule.schedule();
        Assert.assertTrue((String)"Initialization succeeded", (boolean)this.fModule.waitForInitialization());
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testProperties() {
        Map properties = this.fModule.getProperties();
        Assert.assertEquals((Object)this.fModule.getBackendName(), properties.get(Messages.TmfStateSystemAnalysisModule_PropertiesBackend));
        Assert.assertEquals((Object)this.fModule.getId(), properties.get(org.eclipse.tracecompass.tmf.core.analysis.Messages.TmfAbstractAnalysisModule_LabelId));
    }

    private static void setupDependentAnalysisHandler(CyclicBarrier barrier) {
        TestStateSystemProvider.setEventHandler((ss, event) -> {
            try {
                barrier.await();
                if (event.getName().equals(CRUCIAL_EVENT)) {
                    String crucialInfo = (String)event.getContent().getField(new String[]{CRUCIAL_FIELD}).getValue();
                    int quark = ss.getQuarkAbsoluteAndAdd(new String[]{CRUCIAL_FIELD});
                    try {
                        ss.modifyAttribute(event.getTimestamp().toNanos(), (ITmfStateValue)TmfStateValue.newValueString((String)crucialInfo), quark);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                barrier.await();
                return true;
            }
            catch (InterruptedException | BrokenBarrierException e1) {
                return false;
            }
        });
    }

    @Test
    public void testIsQueryable() {
        CyclicBarrier barrier = new CyclicBarrier(2);
        StateSystemAnalysisModuleTest.setupDependentAnalysisHandler(barrier);
        TestStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)((Object)module));
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
        module.schedule();
        Assert.assertTrue((boolean)module.waitForInitialization());
        Assert.assertFalse((boolean)module.isQueryable(1L));
        try {
            try {
                barrier.await();
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertFalse((boolean)module.isQueryable(7L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertFalse((boolean)module.isQueryable(7L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertTrue((boolean)module.isQueryable(7L));
                Assert.assertFalse((boolean)module.isQueryable(10L));
                barrier.await();
                this.fModule.waitForCompletion();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertTrue((boolean)module.isQueryable(7L));
                Assert.assertTrue((boolean)module.isQueryable(10L));
                Assert.assertTrue((boolean)module.isQueryable(100L));
            }
            catch (InterruptedException | BrokenBarrierException e1) {
                Assert.fail((String)e1.getMessage());
                this.fModule.cancel();
                TestStateSystemProvider.setEventHandler(null);
            }
        }
        finally {
            TestStateSystemProvider.setEventHandler(null);
        }
    }

    @Ignore(value="Hangs very often")
    @Test
    public void testIsQueryableCancel() {
        TestStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)((Object)module));
        module.setPerEventSignalling(true);
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
        this.fModule.schedule();
        Assert.assertTrue((boolean)module.waitForInitialization());
        Assert.assertFalse((boolean)module.isQueryable(1L));
        module.signalNextEvent();
        module.signalNextEvent();
        module.cancel();
        module.setPerEventSignalling(false);
        this.fModule.waitForCompletion();
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
    }
}

