/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TmfTraceUtilsTest {
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private TmfTrace fTrace;

    @Before
    public void setUp() {
        try {
            URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TEST_TRACE.getFullPath()), null);
            File test = new File(FileLocator.toFileURL((URL)location).toURI());
            this.fTrace = new TmfTraceStubWithAspects(test.toURI().getPath());
            TmfSignalManager.deregister((Object)this.fTrace);
            this.fTrace.indexTrace(true);
        }
        catch (IOException | URISyntaxException | TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
        this.fTrace = null;
    }

    @Test
    public void testGetModulesByClass() {
        TestAnalysis module2;
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        Iterable testModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TestAnalysis.class);
        Assert.assertTrue((boolean)testModules.iterator().hasNext());
        int count = 0;
        for (TestAnalysis module2 : testModules) {
            Assert.assertNotNull((Object)((Object)module2));
            ++count;
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        module2 = (TestAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TestAnalysis.class, (String)"org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)((Object)module2));
        IAnalysisModule traceModule = trace.getAnalysisModule("org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)traceModule);
        Assert.assertEquals((Object)((Object)module2), (Object)traceModule);
    }

    @Test
    public void testResolveEventAspectsOfClassForEvent() {
        TmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        ITmfContext context = trace.seekEvent(0L);
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, TmfCpuAspect.class, (ITmfEvent)event);
        Assert.assertNotNull((Object)cpuObj);
        Assert.assertEquals((Object)1, (Object)cpuObj);
    }

    private static class TmfTraceStubWithAspects
    extends TmfTraceStub {
        private static final @NonNull Collection<ITmfEventAspect<?>> EVENT_ASPECTS;

        static {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new TmfCpuAspect(){

                public Integer resolve(ITmfEvent event) {
                    return 1;
                }
            });
            builder.addAll((Iterable)TmfTrace.BASE_ASPECTS);
            EVENT_ASPECTS = builder.build();
        }

        public TmfTraceStubWithAspects(String path) throws TmfTraceException {
            super(path, 1000, false, null);
        }

        public Iterable<ITmfEventAspect<?>> getEventAspects() {
            return EVENT_ASPECTS;
        }
    }
}

