/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint.AbstractIndexTest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfEmptyTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TmfCheckpointIndexTest2 {
    private static final int BLOCK_SIZE = 100;
    private static final int NB_EVENTS = 702;
    private static TestTrace fTrace = null;
    private static EmptyTestTrace fEmptyTrace = null;

    @Before
    public void setUp() {
        this.setupTrace(TmfTestTrace.A_TEST_10K2.getFullPath());
    }

    @After
    public void tearDown() {
        fTrace.dispose();
        fTrace = null;
        fEmptyTrace.dispose();
        fEmptyTrace = null;
    }

    private synchronized void setupTrace(String path) {
        if (fTrace == null) {
            try {
                URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
                File test = new File(FileLocator.toFileURL((URL)location).toURI());
                fTrace = new TestTrace(test.toURI().getPath(), 100);
                fTrace.indexTrace(true);
            }
            catch (TmfTraceException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (fEmptyTrace == null) {
            try {
                File file = File.createTempFile("empty", "txt");
                fEmptyTrace = new EmptyTestTrace(file.getAbsolutePath());
            }
            catch (IOException | TmfTraceException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testTmfTraceMultiTimestamps() {
        Assert.assertEquals((String)"getCacheSize", (long)100L, (long)fTrace.getCacheSize());
        Assert.assertEquals((String)"getTraceSize", (long)702L, (long)fTrace.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)1L, (long)fTrace.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)102L, (long)fTrace.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)fTrace.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)102L, (long)fTrace.getEndTime().getValue());
        ITmfCheckpointIndex checkpoints = fTrace.getIndexer().getCheckpoints();
        Assert.assertTrue((String)"Checkpoints exist", (checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Checkpoints size", (long)8L, (long)checkpoints.size());
        ITmfTimestamp seekTs = TmfTimestamp.create((long)101L, (int)-3);
        ITmfContext ctx = fTrace.seekEvent(seekTs);
        ITmfEvent event = fTrace.getNext(ctx);
        Assert.assertEquals((long)99L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)100L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)101L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        seekTs = TmfTimestamp.create((long)102L, (int)-3);
        ctx = fTrace.seekEvent(seekTs);
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)102L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        seekTs = TmfTimestamp.create((long)1L, (int)-3);
        ctx = fTrace.seekEvent(seekTs);
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)1L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        seekTs = TmfTimestamp.create((long)0L, (int)-3);
        ctx = fTrace.seekEvent(seekTs);
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)1L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)TmfTimestamp.create((long)1L, (int)-3).compareTo(event.getTimestamp()));
        seekTs = TmfTimestamp.create((long)50L, (int)-3);
        ctx = fTrace.seekEvent(seekTs);
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)50L, (long)ctx.getRank());
        Assert.assertEquals((long)0L, (long)seekTs.compareTo(event.getTimestamp()));
        seekTs = TmfTimestamp.create((long)103L, (int)-3);
        ctx = fTrace.seekEvent(seekTs);
        event = fTrace.getNext(ctx);
        Assert.assertEquals((long)-1L, (long)ctx.getRank());
        Assert.assertNull((Object)event);
    }

    private class EmptyTestTrace
    extends TmfEmptyTraceStub {
        public EmptyTestTrace(String path) throws TmfTraceException {
            super(path);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return new TestIndexer(this);
        }

        public AbstractIndexTest.ITestIndexer getIndexer() {
            return (AbstractIndexTest.ITestIndexer)super.getIndexer();
        }
    }

    private static class TestIndexer
    extends TmfCheckpointIndexer
    implements AbstractIndexTest.ITestIndexer {
        public TestIndexer(TestTrace testTrace) {
            super((ITmfTrace)testTrace, 100);
        }

        public TestIndexer(EmptyTestTrace testTrace) {
            super((ITmfTrace)testTrace, 100);
        }

        @Override
        public ITmfCheckpointIndex getCheckpoints() {
            return this.getTraceIndex();
        }
    }

    private class TestTrace
    extends TmfTraceStub {
        public TestTrace(String path, int blockSize) throws TmfTraceException {
            super(path, blockSize, false, null);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return new TestIndexer(this);
        }

        public AbstractIndexTest.ITestIndexer getIndexer() {
            return (AbstractIndexTest.ITestIndexer)super.getIndexer();
        }
    }
}

