/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.text;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEventContent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogEvent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TextTraceTest {
    private static final String NAME = "syslog";
    private static final String PATH = "testfiles/syslog";
    private static final String OTHER_PATH = "testfiles/A-Test-10K";
    private static SyslogTrace fTrace = null;
    private static File fTestFile = null;

    @BeforeClass
    public static void setUp() throws Exception {
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "MMM d HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.locale", Locale.CANADA.toLanguageTag());
        TmfTimestampFormat.updateDefaultFormats();
        if (fTrace == null) {
            try {
                URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(PATH), null);
                URI uri = FileLocator.toFileURL((URL)location).toURI();
                fTestFile = new File(uri);
                fTrace = new SyslogTrace();
                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PATH));
                fTrace.initTrace((IResource)resource, uri.getPath(), SyslogEvent.class);
                TmfEventRequest request = new TmfEventRequest(SyslogEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND){};
                fTrace.sendRequest((ITmfEventRequest)request);
                request.waitForCompletion();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @AfterClass
    public static void tearDown() {
        fTrace.dispose();
        fTrace = null;
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "SSS SSS SSS");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.locale", Locale.getDefault().toLanguageTag());
        TmfTimestampFormat.updateDefaultFormats();
    }

    @Test
    public void testEmptyConstructor() {
        SyslogTrace trace = new SyslogTrace();
        Assert.assertEquals((String)"getEventType", null, (Object)trace.getEventType());
        Assert.assertEquals((String)"getPath", null, (Object)trace.getPath());
        Assert.assertEquals((String)"getName", (Object)"", (Object)trace.getName());
        Assert.assertEquals((String)"getCacheSize", (long)100L, (long)trace.getCacheSize());
        ITmfTimestamp initRange = TmfTimestamp.fromSeconds((long)60L);
        Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)trace.getInitialRangeOffset());
    }

    @Test
    public void testValidation() throws URISyntaxException, IOException {
        SyslogTrace trace = new SyslogTrace();
        String validTracePath = fTestFile.getAbsolutePath();
        IStatus status = trace.validate(null, validTracePath);
        Assert.assertTrue((boolean)status.isOK());
        Assert.assertTrue((boolean)(status instanceof TraceValidationStatus));
        Assert.assertEquals((long)185L, (long)((TraceValidationStatus)status).getConfidence());
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(OTHER_PATH), null);
        URI uri = FileLocator.toFileURL((URL)location).toURI();
        File otherFile = new File(uri);
        String validNoConfidenceTrace = otherFile.getAbsolutePath();
        status = trace.validate(null, validNoConfidenceTrace);
        Assert.assertTrue((boolean)(status instanceof TraceValidationStatus));
        Assert.assertEquals((long)0L, (long)((TraceValidationStatus)status).getConfidence());
        Assert.assertTrue((boolean)status.isOK());
        String invalidTrace = fTestFile.getParentFile().getAbsolutePath();
        status = trace.validate(null, invalidTrace);
        Assert.assertFalse((boolean)status.isOK());
    }

    @Test
    public void testInitTrace() throws Exception {
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(PATH), null);
        String path = FileLocator.toFileURL((URL)location).toURI().getPath();
        SyslogTrace trace = new SyslogTrace();
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PATH));
        trace.initTrace((IResource)resource, path, SyslogEvent.class);
        Assert.assertEquals((String)"getEventType", SyslogEvent.class, (Object)trace.getEventType());
        Assert.assertEquals((String)"getPath", (Object)fTestFile.toURI().getPath(), (Object)trace.getPath());
        Assert.assertEquals((String)"getName", (Object)NAME, (Object)trace.getName());
        Assert.assertEquals((String)"getCacheSize", (long)100L, (long)trace.getCacheSize());
    }

    @Test
    public void testTraceIndexing() {
        Assert.assertEquals((String)"getNbEvents", (long)6L, (long)fTrace.getNbEvents());
        ITmfTimestamp initRange = TmfTimestamp.fromSeconds((long)60L);
        Assert.assertEquals((String)"getInitialRangeOffset", (Object)initRange, (Object)fTrace.getInitialRangeOffset());
    }

    @Test
    public void testTraceParsing() {
        ITmfContext context = fTrace.seekEvent(0L);
        SyslogEvent event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        TextTraceEventContent content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 01:01:01", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostA", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerA", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileA", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"4", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"Message A", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 02:02:02", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostB", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerB", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileB", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"5", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"Message B", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 03:03:03", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostC", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerC", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileC", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"6", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"Message C", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 04:04:04", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostD", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerD", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileD", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"7", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"Message D", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 05:05:05", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostE", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerE", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileE", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"8", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getTimestamp", (Object)"Jan 1 06:06:06", (Object)event.getTimestamp().toString());
        Assert.assertEquals((String)"getField:HOST", (Object)"HostF", (Object)content.getFieldValue("Host"));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerF", (Object)content.getFieldValue("Logger"));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileF", (Object)content.getFieldValue("File"));
        Assert.assertEquals((String)"getField:LINE", (Object)"9", (Object)content.getFieldValue("Line"));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"Message F", (Object)content.getFieldValue("Message").toString());
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertEquals((String)"event", null, (Object)((Object)event));
        context.dispose();
    }

    @Test
    public void testLocationRatio() {
        ITmfContext context = fTrace.seekEvent(3L);
        double ratio = fTrace.getLocationRatio(context.getLocation());
        SyslogEvent event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        TextTraceEventContent content = event.getContent();
        Object logger = content.getFieldValue("Logger");
        context.dispose();
        context = fTrace.seekEvent(ratio);
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getField:LOGGER", (Object)logger.toString(), (Object)content.getFieldValue("Logger").toString());
        context.dispose();
        context = fTrace.seekEvent(0.0);
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertNotNull((Object)((Object)event));
        content = event.getContent();
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerA", (Object)content.getFieldValue("Logger"));
        context.dispose();
        context = fTrace.seekEvent(1.0);
        event = (SyslogEvent)fTrace.getNext(context);
        Assert.assertEquals((String)"event", null, (Object)((Object)event));
        context.dispose();
    }
}

