/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemProvider;

@NonNullByDefault
public class TestStateSystemModule
extends TmfStateSystemAnalysisModule {
    private @Nullable TestStateSystemProvider fProvider = null;
    private boolean fThrottleEvents = false;

    protected ITmfStateProvider createStateProvider() {
        TestStateSystemProvider provider;
        this.fProvider = provider = new TestStateSystemProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
        boolean throttle = this.fThrottleEvents;
        provider.setThrottling(throttle);
        return provider;
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM;
    }

    public String getBackendName() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.INMEM.name();
    }

    public void setPerEventSignalling(boolean throttleEvent) {
        this.fThrottleEvents = throttleEvent;
        TestStateSystemProvider provider = this.fProvider;
        if (provider != null) {
            provider.setThrottling(throttleEvent);
        }
    }

    public void signalNextEvent() {
        TestStateSystemProvider provider = this.fProvider;
        if (provider != null) {
            provider.signalNextEvent();
        }
    }
}

