/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.analysis;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TestStateSystemProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private static final String fString = "[]";
    private static int fCount = 0;
    private static final @NonNull TestStateProviderHandler DEFAULT_HANDLER;
    private static @NonNull TestStateProviderHandler sfHandler;
    private final Lock fLock = new ReentrantLock();
    private @Nullable Condition fNextEventSignal = null;

    static {
        sfHandler = DEFAULT_HANDLER = (ss, event) -> {
            if (fString.equals(event.getContent().getValue())) {
                try {
                    int quarkId = ss.getQuarkAbsoluteAndAdd(new String[]{"String"});
                    int quark = ss.getQuarkRelativeAndAdd(quarkId, new String[]{fString});
                    ss.modifyAttribute(event.getTimestamp().getValue(), (ITmfStateValue)TmfStateValue.newValueInt((int)fCount++), quark);
                }
                catch (StateValueTypeException | TimeRangeException throwable) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static void setEventHandler(TestStateProviderHandler handler) {
        if (handler == null) {
            sfHandler = DEFAULT_HANDLER;
            return;
        }
        sfHandler = handler;
    }

    public TestStateSystemProvider(@NonNull ITmfTrace trace) {
        super(trace, "Stub State System");
    }

    public int getVersion() {
        return 1;
    }

    public ITmfStateProvider getNewInstance() {
        return new TestStateSystemProvider(this.getTrace());
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        sfHandler.eventHandle(ss, event);
    }

    public void processEvent(@NonNull ITmfEvent event) {
        this.fLock.lock();
        try {
            try {
                Condition cond = this.fNextEventSignal;
                if (cond != null) {
                    cond.await();
                }
            }
            catch (InterruptedException interruptedException) {
                super.processEvent(event);
                this.fLock.unlock();
            }
        }
        finally {
            super.processEvent(event);
            this.fLock.unlock();
        }
    }

    public void setThrottling(boolean throttleEvent) {
        this.fLock.lock();
        try {
            if (throttleEvent) {
                Condition cond = this.fNextEventSignal;
                if (cond == null) {
                    this.fNextEventSignal = cond = this.fLock.newCondition();
                }
            } else {
                Condition cond = this.fNextEventSignal;
                if (cond != null) {
                    this.fNextEventSignal = null;
                    cond.signalAll();
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void signalNextEvent() {
        this.fLock.lock();
        try {
            Condition cond = this.fNextEventSignal;
            if (cond != null) {
                cond.signalAll();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @FunctionalInterface
    public static interface TestStateProviderHandler {
        public boolean eventHandle(@NonNull ITmfStateSystemBuilder var1, ITmfEvent var2);
    }
}

