/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.parsers.custom;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;

public class CustomEventAspects {
    public static @NonNull Iterable<ITmfEventAspect<?>> generateAspects(CustomTraceDefinition definition) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (CustomTraceDefinition.OutputColumn output : definition.outputs) {
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP) && (definition.timeStampOutputFormat == null || definition.timeStampOutputFormat.isEmpty())) {
                builder.add(TmfBaseAspects.getTimestampAspect());
                continue;
            }
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.EVENT_TYPE)) {
                builder.add(TmfBaseAspects.getEventTypeAspect());
                continue;
            }
            builder.add((Object)new TmfContentFieldAspect(output.name, output.name));
        }
        return builder.build();
    }
}

