/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;

public class TmfTimestampFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 2835829763122454020L;
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss.SSS SSS SSS";
    public static final String DEFAULT_INTERVAL_PATTERN = "TTT.SSS SSS SSS";
    private static TmfTimestampFormat fDefaultTimeFormat = null;
    private static TmfTimestampFormat fDefaultIntervalFormat = null;
    private String fPattern;
    private int fPatternDecimalSeparatorIndex;
    private char fDecimalSeparator = '\u0000';
    private String fDateTimePattern;
    private String fSubSecPattern;
    private List<String> fSupplPatterns = new ArrayList<String>();
    private long fUnitOfSeconds = 1L;
    private final Locale fLocale;
    protected String fSupplPatternLetters = "TSCN";
    protected String fSubSecPatternChars = "SCN";
    protected String fDelimiterChars = " .,-_:;/'\"";
    protected Map<Character, Long> fUnitOfSecondsMap = new HashMap<Character, Long>();
    protected String fOpenBracket;
    protected String fCloseBracket;

    public TmfTimestampFormat() {
        this(TmfTimePreferences.getTimePattern());
    }

    public TmfTimestampFormat(String pattern) {
        this.fUnitOfSecondsMap.put(Character.valueOf('d'), 10L);
        this.fUnitOfSecondsMap.put(Character.valueOf('c'), 100L);
        this.fUnitOfSecondsMap.put(Character.valueOf('m'), 1000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('u'), 1000000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('n'), 1000000000L);
        this.fOpenBracket = "[&";
        this.fCloseBracket = "&]";
        this.fLocale = Locale.getDefault();
        this.applyPattern(pattern);
    }

    public TmfTimestampFormat(String pattern, TimeZone timeZone) {
        this.fUnitOfSecondsMap.put(Character.valueOf('d'), 10L);
        this.fUnitOfSecondsMap.put(Character.valueOf('c'), 100L);
        this.fUnitOfSecondsMap.put(Character.valueOf('m'), 1000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('u'), 1000000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('n'), 1000000000L);
        this.fOpenBracket = "[&";
        this.fCloseBracket = "&]";
        this.fLocale = Locale.getDefault();
        this.setTimeZone(timeZone);
        this.applyPattern(pattern);
    }

    public TmfTimestampFormat(String pattern, TimeZone timeZone, Locale locale) {
        super("", locale);
        this.fUnitOfSecondsMap.put(Character.valueOf('d'), 10L);
        this.fUnitOfSecondsMap.put(Character.valueOf('c'), 100L);
        this.fUnitOfSecondsMap.put(Character.valueOf('m'), 1000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('u'), 1000000L);
        this.fUnitOfSecondsMap.put(Character.valueOf('n'), 1000000000L);
        this.fOpenBracket = "[&";
        this.fCloseBracket = "&]";
        this.fLocale = locale;
        this.setTimeZone(timeZone);
        this.setCalendar(Calendar.getInstance(timeZone, locale));
        this.applyPattern(pattern);
    }

    public TmfTimestampFormat(TmfTimestampFormat other) {
        this(other.fPattern, other.getTimeZone(), other.fLocale);
    }

    public static synchronized void updateDefaultFormats() {
        fDefaultTimeFormat = new TmfTimestampFormat(TmfTimePreferences.getTimePattern(), TmfTimePreferences.getTimeZone(), TmfTimePreferences.getLocale());
        fDefaultIntervalFormat = new TmfTimestampFormat(TmfTimePreferences.getIntervalPattern());
    }

    public static synchronized TmfTimestampFormat getDefaulTimeFormat() {
        if (fDefaultTimeFormat == null) {
            fDefaultTimeFormat = new TmfTimestampFormat(TmfTimePreferences.getTimePattern(), TmfTimePreferences.getTimeZone(), TmfTimePreferences.getLocale());
        }
        return fDefaultTimeFormat;
    }

    public static synchronized TmfTimestampFormat getDefaulIntervalFormat() {
        if (fDefaultIntervalFormat == null) {
            fDefaultIntervalFormat = new TmfTimestampFormat(TmfTimePreferences.getIntervalPattern());
        }
        return fDefaultIntervalFormat;
    }

    @Override
    public void applyPattern(String pattern) {
        this.fPattern = pattern;
        this.fPatternDecimalSeparatorIndex = this.indexOfPatternDecimalSeparator(pattern);
        this.fDateTimePattern = TmfTimestampFormat.unquotePattern(pattern.substring(0, this.fPatternDecimalSeparatorIndex));
        if (this.fDateTimePattern.indexOf(83) != -1) {
            throw new IllegalArgumentException("Illegal pattern character 'S'");
        }
        if (this.fDateTimePattern.indexOf(87) != -1) {
            throw new IllegalArgumentException("Illegal pattern character 'W'");
        }
        super.applyPattern(this.quoteSpecificTags(pattern.substring(0, this.fPatternDecimalSeparatorIndex), true));
        this.fSubSecPattern = this.quoteSpecificTags(pattern.substring(this.fPatternDecimalSeparatorIndex), false);
    }

    @Override
    public String toPattern() {
        return this.fPattern;
    }

    public synchronized String format(long value) {
        long date = value / 1000000L;
        long sec = value / 1000000000L;
        long ms = Math.abs(value % 1000000000L / 1000000L);
        long us = Math.abs(value % 1000000L / 1000L);
        long ns = Math.abs(value % 1000L);
        if (value < 0L && ms + us + ns > 0L && !super.toPattern().contains(String.valueOf(this.fOpenBracket) + "T")) {
            --date;
            long nanosec = 1000000000L - (1000000L * ms + 1000L * us + ns);
            ms = nanosec / 1000000L;
            us = nanosec % 1000000L / 1000L;
            ns = nanosec % 1000L;
        }
        StringBuffer result = new StringBuffer(super.format(date));
        result.append(this.fSubSecPattern);
        int fractionDigitsPrinted = 0;
        for (String pattern : this.fSupplPatterns) {
            int length = pattern.length();
            long val = 0L;
            int bufLength = 0;
            switch (pattern.charAt(0)) {
                case 'T': {
                    if (value < 0L && sec == 0L) {
                        result.insert(0, '-');
                    }
                    val = sec;
                    if (this.fUnitOfSeconds != 1L) {
                        val = value / (1000000000L / this.fUnitOfSeconds);
                    }
                    bufLength = Math.min(length, 10);
                    break;
                }
                case 'S': {
                    val = 1000000L * ms + 1000L * us + ns;
                    if (this.fUnitOfSeconds != 1L) {
                        val *= this.fUnitOfSeconds;
                        val %= 1000000000L;
                    }
                    bufLength = 9;
                    break;
                }
                case 'C': {
                    val = us;
                    bufLength = Math.min(length, 3);
                    break;
                }
                case 'N': {
                    val = ns;
                    bufLength = Math.min(length, 3);
                    break;
                }
            }
            StringBuffer fmt = new StringBuffer();
            int i = 0;
            while (i < bufLength) {
                fmt.append("0");
                ++i;
            }
            DecimalFormat dfmt = new DecimalFormat(fmt.toString());
            String fmtVal = dfmt.format(val);
            if (pattern.charAt(0) == 'S') {
                fmtVal = fmtVal.substring(fractionDigitsPrinted, Math.min(bufLength, fractionDigitsPrinted + length));
                fractionDigitsPrinted += fmtVal.length();
            }
            String ph = new StringBuffer(String.valueOf(this.fOpenBracket) + pattern + this.fCloseBracket).toString();
            int loc = result.indexOf(ph);
            result.replace(loc, loc + length + this.fOpenBracket.length() + this.fCloseBracket.length(), fmtVal);
        }
        return result.toString();
    }

    public synchronized long parseValue(String source, long ref) throws ParseException {
        if (source == null || source.length() == 0) {
            return 0L;
        }
        int index = this.indexOfSourceDecimalSeparator(source);
        for (String pattern : this.fSupplPatterns) {
            boolean isNegative;
            if (pattern.charAt(0) != 'T') continue;
            long unitsOfSecond = 0L;
            boolean bl = isNegative = source.charAt(0) == '-';
            if (index == 0 || isNegative && index <= 1) {
                unitsOfSecond = 0L;
            } else {
                if (index == source.length()) {
                    return new DecimalFormat("0").parse(source).longValue() * (1000000000L / this.fUnitOfSeconds);
                }
                unitsOfSecond = new DecimalFormat("0").parse(source.substring(0, index)).longValue();
            }
            long nanos = this.parseSubSeconds(source.substring(index));
            if (isNegative) {
                nanos = -nanos;
            }
            return unitsOfSecond * (1000000000L / this.fUnitOfSeconds) + nanos;
        }
        long seconds = 0L;
        if (super.toPattern().length() > 0) {
            Date baseDate = super.parse(source.substring(0, index));
            this.getCalendar();
            if (ref != Long.MIN_VALUE) {
                Calendar baseTime = Calendar.getInstance(this.getTimeZone(), this.fLocale);
                baseTime.setTimeInMillis(baseDate.getTime());
                Calendar newTime = Calendar.getInstance(this.getTimeZone(), this.fLocale);
                newTime.setTimeInMillis(ref / 1000000L);
                boolean setRemainingFields = false;
                if (this.dateTimePatternContains("yY")) {
                    newTime.set(1, baseTime.get(1));
                    setRemainingFields = true;
                }
                if (setRemainingFields || this.dateTimePatternContains("M")) {
                    newTime.set(2, baseTime.get(2));
                    setRemainingFields = true;
                }
                if (setRemainingFields || this.dateTimePatternContains("d")) {
                    newTime.set(5, baseTime.get(5));
                    setRemainingFields = true;
                } else if (this.dateTimePatternContains("D")) {
                    newTime.set(6, baseTime.get(6));
                    setRemainingFields = true;
                } else if (this.dateTimePatternContains("w")) {
                    newTime.set(3, baseTime.get(3));
                    setRemainingFields = true;
                }
                if (this.dateTimePatternContains("F")) {
                    newTime.set(8, baseTime.get(8));
                    setRemainingFields = true;
                }
                if (this.dateTimePatternContains("Eu")) {
                    newTime.set(7, baseTime.get(7));
                    setRemainingFields = true;
                }
                if (setRemainingFields || this.dateTimePatternContains("aHkKh")) {
                    newTime.set(11, baseTime.get(11));
                    setRemainingFields = true;
                }
                if (setRemainingFields || this.dateTimePatternContains("m")) {
                    newTime.set(12, baseTime.get(12));
                    setRemainingFields = true;
                }
                if (setRemainingFields || this.dateTimePatternContains("s")) {
                    newTime.set(13, baseTime.get(13));
                }
                newTime.set(14, 0);
                seconds = newTime.getTimeInMillis() / 1000L;
            } else {
                seconds = baseDate.getTime() / 1000L;
            }
        } else if (ref != Long.MIN_VALUE) {
            seconds = ref / 1000000000L;
        }
        long nanos = this.parseSubSeconds(source.substring(index));
        return seconds * 1000000000L + nanos;
    }

    public long parseValue(String source) throws ParseException {
        long result = this.parseValue(source, Long.MIN_VALUE);
        return result;
    }

    private int indexOfPatternDecimalSeparator(String pattern) {
        int lastDelimiterIndex = pattern.length();
        boolean inQuote = false;
        int index = 0;
        while (index < pattern.length()) {
            char ch = pattern.charAt(index);
            if (ch == '\'' && index + 1 < pattern.length() && (ch = pattern.charAt(++index)) != '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (!inQuote) {
                if (this.fSubSecPatternChars.indexOf(ch) != -1) {
                    if (lastDelimiterIndex < pattern.length()) {
                        this.fDecimalSeparator = pattern.charAt(lastDelimiterIndex);
                    }
                    return lastDelimiterIndex;
                }
                if (this.fDelimiterChars.indexOf(ch) != -1) {
                    lastDelimiterIndex = index;
                    if (ch == '\'') {
                        --lastDelimiterIndex;
                    }
                }
            }
            ++index;
        }
        return pattern.length();
    }

    private int indexOfSourceDecimalSeparator(String source) {
        String separator = this.fDecimalSeparator == '\'' ? "''" : String.valueOf(this.fDecimalSeparator);
        int patternPos = this.fPattern.indexOf(separator);
        int sourcePos = -1;
        while (patternPos != -1 && patternPos <= this.fPatternDecimalSeparatorIndex) {
            int p;
            if ((sourcePos = source.indexOf(this.fDecimalSeparator, sourcePos + 1)) == -1) break;
            int n = p = patternPos < this.fPattern.length() - 1 ? (int)this.fPattern.charAt(patternPos + 1) : 0;
            if (p >= 97 && p <= 122 || p >= 65 && p <= 90) {
                while (sourcePos < source.length() - 1) {
                    char s = source.charAt(sourcePos + 1);
                    if (s != ' ' && s != '\t') break;
                    ++sourcePos;
                }
            }
            patternPos = this.fPattern.indexOf(separator, patternPos + separator.length());
        }
        if (sourcePos == -1) {
            sourcePos = source.length();
        }
        return sourcePos;
    }

    private long parseSubSeconds(String input) throws ParseException {
        StringBuilder digits = new StringBuilder("000000000");
        String pattern = this.fPattern.substring(this.fPatternDecimalSeparatorIndex);
        boolean inQuote = false;
        int digitIndex = 0;
        int inputIndex = 0;
        int patternIndex = 0;
        while (patternIndex < pattern.length()) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '\'') {
                if (++patternIndex < pattern.length()) {
                    ch = pattern.charAt(patternIndex);
                    if (ch != '\'') {
                        inQuote = !inQuote;
                    }
                } else if (inQuote) break;
            }
            if (this.fDelimiterChars.indexOf(ch) != -1 && !inQuote) {
                if (inputIndex < input.length() && input.charAt(inputIndex) == ch) {
                    ++inputIndex;
                }
                ++patternIndex;
                continue;
            }
            if (this.fSubSecPatternChars.indexOf(ch) != -1 && !inQuote) {
                if (inputIndex < input.length() && Character.isDigit(input.charAt(inputIndex))) {
                    if (digitIndex < digits.length()) {
                        digits.setCharAt(digitIndex, input.charAt(inputIndex));
                        ++digitIndex;
                    }
                    ++inputIndex;
                } else {
                    digitIndex = digits.length();
                }
                ++patternIndex;
                continue;
            }
            if (inputIndex >= input.length() || input.charAt(inputIndex) != ch) {
                throw new ParseException("Unparseable sub-seconds: \"" + input + '\"', inputIndex);
            }
            ++patternIndex;
            ++inputIndex;
        }
        return Long.parseLong(digits.toString()) / this.fUnitOfSeconds;
    }

    private String quoteSpecificTags(String pattern, boolean includeQuotes) {
        StringBuffer result = new StringBuffer();
        int length = pattern.length();
        boolean inQuote = false;
        int i = 0;
        while (i < length) {
            char c = pattern.charAt(i);
            if (c != '\'' || includeQuotes) {
                result.append(c);
            }
            if (c == '\'') {
                if (i + 1 < length && (c = pattern.charAt(i + 1)) == '\'') {
                    ++i;
                    result.append(c);
                } else {
                    inQuote = !inQuote;
                }
            } else if (!inQuote && this.fSupplPatternLetters.indexOf(c) != -1 && !(pattern.charAt(0) == this.fDecimalSeparator ? this.fSubSecPatternChars.indexOf(c) == -1 : this.fSubSecPatternChars.indexOf(c) != -1)) {
                Long unitOfSeconds;
                StringBuilder pat = new StringBuilder();
                pat.append(c);
                if (includeQuotes) {
                    result.insert(result.length() - 1, "'");
                }
                result.insert(result.length() - 1, this.fOpenBracket);
                while (i + 1 < length && pattern.charAt(i + 1) == c) {
                    result.append(c);
                    pat.append(c);
                    ++i;
                }
                if (c == 'T' && i + 1 < length && (unitOfSeconds = this.fUnitOfSecondsMap.get(Character.valueOf(c = pattern.charAt(i + 1)))) != null) {
                    this.fUnitOfSeconds = unitOfSeconds;
                    ++i;
                }
                result.append(this.fCloseBracket);
                if (includeQuotes) {
                    result.append("'");
                }
                this.fSupplPatterns.add(pat.toString());
            }
            ++i;
        }
        return result.toString();
    }

    private static String unquotePattern(String pattern) {
        boolean inQuote = false;
        int index = 0;
        StringBuilder result = new StringBuilder();
        while (index < pattern.length()) {
            char ch = pattern.charAt(index);
            if (ch == '\'' && index + 1 < pattern.length() && (ch = pattern.charAt(++index)) != '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (!inQuote) {
                result.append(ch);
            }
            ++index;
        }
        return result.toString();
    }

    private boolean dateTimePatternContains(String chars) {
        int index = 0;
        while (index < chars.length()) {
            char ch = chars.charAt(index);
            if (this.fDateTimePattern.indexOf(ch) != -1) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

