/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.perf.experiment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.junit.Test;

public class ExperimentBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Experiment benchmark#";
    private static final int MAX_TRACES = 160;
    private static final int BLOCK_SIZE = 100;
    private static final String TRACES_ROOT_PATH;
    private static final int SAMPLE_SIZE_SLOW = 20;
    private static final int SAMPLE_SIZE = 100;
    private TmfExperimentStub fExperiment;

    static {
        try {
            TRACES_ROOT_PATH = FileLocator.toFileURL((URL)CtfTestTrace.TRACE_EXPERIMENT.getTraceURL()).getPath();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    @Test
    public void benchmarkExperimentSizeRequest() {
        Performance perf = Performance.getDefault();
        int numTraces = 1;
        while (numTraces < 160) {
            PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + numTraces + " traces");
            perf.tagAsSummary(pm, "Experiment Benchmark:" + numTraces + " traces", Dimension.CPU_TIME);
            if ((int)(1.6 * (double)(numTraces + 1)) > 160) {
                perf.tagAsGlobalSummary(pm, "Experiment Benchmark:" + numTraces + " traces", Dimension.CPU_TIME);
            }
            int sampleSize = 100;
            if (numTraces > 20) {
                sampleSize = 20;
            }
            int s = 0;
            while (s < sampleSize) {
                InnerEventRequest expReq = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
                InnerEventRequest[] traceReq = new InnerEventRequest[numTraces];
                this.init(numTraces);
                this.fExperiment.sendRequest((ITmfEventRequest)expReq);
                List traces = this.fExperiment.getTraces();
                int i = 0;
                while (i < numTraces) {
                    traceReq[i] = new InnerEventRequest(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
                    ((ITmfTrace)traces.get(i)).sendRequest((ITmfEventRequest)traceReq[i]);
                    ++i;
                }
                pm.start();
                ExperimentBenchmark.waitForRequest(expReq, traceReq);
                pm.stop();
                i = 0;
                while (i < traces.size()) {
                    if (!expReq.isTraceHandled((ITmfTrace)traces.get(i))) {
                        System.err.println("Trace " + i + " not handled!");
                    }
                    ++i;
                }
                this.fExperiment.dispose();
                ++s;
            }
            pm.commit();
            numTraces = (int)(1.6 * (double)(numTraces + 1));
        }
    }

    private void init(int maxTraces) {
        try {
            File parentDir = new File(TRACES_ROOT_PATH);
            File[] traceFiles = parentDir.listFiles();
            CtfTmfTrace[] traces = new CtfTmfTrace[Math.min(maxTraces, traceFiles.length)];
            int i = 0;
            while (i < traces.length) {
                traces[i] = new CtfTmfTrace();
                ++i;
            }
            this.fExperiment = new TmfExperimentStub("MegaExperiment", (ITmfTrace[])traces, 100);
            int j = 0;
            int i2 = 0;
            while (i2 < traces.length && j < traces.length) {
                String absolutePath = traceFiles[j].getAbsolutePath();
                if (traces[i2].validate(null, absolutePath).isOK()) {
                    traces[i2].initTrace(null, absolutePath, ITmfEvent.class);
                } else {
                    --i2;
                }
                ++j;
                ++i2;
            }
            if (traces[traces.length - 1].getPath() == null) {
                throw new TmfTraceException("Insufficient valid traces in directory");
            }
        }
        catch (TmfTraceException e) {
            System.out.println(e.getMessage());
        }
    }

    private static void waitForRequest(InnerEventRequest expReq, InnerEventRequest[] traceReqs) {
        try {
            expReq.waitForCompletion();
            List<InnerEventRequest> reqs = Arrays.asList(traceReqs);
            for (InnerEventRequest traceReq : reqs) {
                traceReq.waitForCompletion();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class InnerEventRequest
    extends TmfEventRequest {
        private Set<String> fTraces = new HashSet<String>();

        public InnerEventRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
            super(dataType, index, nbRequested, priority);
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (!this.fTraces.contains(event.getTrace().getName())) {
                this.fTraces.add(event.getTrace().getName());
            }
        }

        public boolean isTraceHandled(ITmfTrace trace) {
            return this.fTraces.contains(trace.getName());
        }
    }
}

