/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.shared;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.stubs.CtfTmfTraceStub;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public final class CtfTmfTestTraceUtils {
    private static final Map<CtfTestTrace, CtfTmfTrace> CTF_TMF_TRACES = new HashMap<CtfTestTrace, CtfTmfTrace>();

    private CtfTmfTestTraceUtils() {
    }

    public static synchronized CtfTmfTrace getTrace(CtfTestTrace ctfTrace) {
        String tracePath;
        try {
            tracePath = FileLocator.toFileURL((URL)ctfTrace.getTraceURL()).getPath();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        CtfTmfTestTraceUtils.dispose(ctfTrace);
        CtfTmfTraceStub trace = new CtfTmfTraceStub();
        try {
            trace.initTrace(null, tracePath, CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
        CTF_TMF_TRACES.put(ctfTrace, trace);
        return trace;
    }

    public static synchronized void dispose(CtfTestTrace ctfTrace) {
        CtfTmfTrace trace = CTF_TMF_TRACES.remove(ctfTrace);
        if (trace != null) {
            trace.dispose();
        }
    }

    public static CtfTmfTrace getSyntheticTrace() {
        CtfTmfTrace trace = new CtfTmfTrace();
        try {
            trace.initTrace(null, LttngTraceGenerator.getPath(), CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new IllegalStateException();
        }
        return trace;
    }
}

